/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.application_security_domain.SingleSignOnSetting;
import org.wildfly.swarm.config.undertow.application_security_domain.SingleSignOnSettingConsumer;
import org.wildfly.swarm.config.undertow.application_security_domain.SingleSignOnSettingSupplier;

@Address(value="/subsystem=undertow/application-security-domain=*")
@ResourceType(value="application-security-domain")
public class ApplicationSecurityDomain<T extends ApplicationSecurityDomain<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ApplicationSecurityDomainResources subresources = new ApplicationSecurityDomainResources();
    @AttributeDocumentation(value="Enable authorization using JACC")
    private Boolean enableJacc;
    @AttributeDocumentation(value="Enable JASPI authentication for the associated deployments.")
    private Boolean enableJaspi;
    @AttributeDocumentation(value="The HTTP Authentication Factory to be used by deployments that reference the mapped security domain.")
    private String httpAuthenticationFactory;
    @AttributeDocumentation(value="Whether integrated JASPI should be used. If 'false', an ad hoc identity will be created instead.")
    private Boolean integratedJaspi;
    @AttributeDocumentation(value="Should the authentication configuration in the deployment be overridden by the factory.")
    private Boolean overrideDeploymentConfig;
    @AttributeDocumentation(value="The deployments currently referencing this mapping.")
    private List<String> referencingDeployments;
    @AttributeDocumentation(value="The SecurityDomain to be used by deployments that reference the mapped security domain.")
    private String securityDomain;

    public ApplicationSecurityDomain(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ApplicationSecurityDomainResources subresources() {
        return this.subresources;
    }

    public T singleSignOnSetting(SingleSignOnSetting value) {
        this.subresources.singleSignOnSetting = value;
        return (T)this;
    }

    public T singleSignOnSetting(SingleSignOnSettingConsumer consumer) {
        SingleSignOnSetting child = new SingleSignOnSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.singleSignOnSetting = child;
        return (T)this;
    }

    public T singleSignOnSetting() {
        SingleSignOnSetting child = new SingleSignOnSetting();
        this.subresources.singleSignOnSetting = child;
        return (T)this;
    }

    public T singleSignOnSetting(SingleSignOnSettingSupplier supplier) {
        this.subresources.singleSignOnSetting = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-jacc")
    public Boolean enableJacc() {
        return this.enableJacc;
    }

    public T enableJacc(Boolean value) {
        Boolean oldValue = this.enableJacc;
        this.enableJacc = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableJacc", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-jaspi")
    public Boolean enableJaspi() {
        return this.enableJaspi;
    }

    public T enableJaspi(Boolean value) {
        Boolean oldValue = this.enableJaspi;
        this.enableJaspi = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableJaspi", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http-authentication-factory")
    public String httpAuthenticationFactory() {
        return this.httpAuthenticationFactory;
    }

    public T httpAuthenticationFactory(String value) {
        String oldValue = this.httpAuthenticationFactory;
        this.httpAuthenticationFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("httpAuthenticationFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="integrated-jaspi")
    public Boolean integratedJaspi() {
        return this.integratedJaspi;
    }

    public T integratedJaspi(Boolean value) {
        Boolean oldValue = this.integratedJaspi;
        this.integratedJaspi = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("integratedJaspi", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="override-deployment-config")
    public Boolean overrideDeploymentConfig() {
        return this.overrideDeploymentConfig;
    }

    public T overrideDeploymentConfig(Boolean value) {
        Boolean oldValue = this.overrideDeploymentConfig;
        this.overrideDeploymentConfig = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("overrideDeploymentConfig", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="referencing-deployments")
    public List<String> referencingDeployments() {
        return this.referencingDeployments;
    }

    public T referencingDeployments(List<String> value) {
        List<String> oldValue = this.referencingDeployments;
        this.referencingDeployments = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("referencingDeployments", oldValue, value);
        }
        return (T)this;
    }

    public T referencingDeployment(String value) {
        if (this.referencingDeployments == null) {
            this.referencingDeployments = new ArrayList<String>();
        }
        this.referencingDeployments.add(value);
        return (T)this;
    }

    public T referencingDeployments(String ... args) {
        this.referencingDeployments(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    public static class ApplicationSecurityDomainResources {
        @SingletonResource
        @ResourceDocumentation(value="An SSO authentication mechanism configuration.")
        private SingleSignOnSetting singleSignOnSetting;

        @Subresource
        public SingleSignOnSetting singleSignOnSetting() {
            return this.singleSignOnSetting;
        }
    }
}

