/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.Balancer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerSupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.NoneAffinity;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.NoneAffinityConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.NoneAffinitySupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.RankedAffinity;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.RankedAffinityConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.RankedAffinitySupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.SingleAffinity;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.SingleAffinityConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.SingleAffinitySupplier;

@Address(value="/subsystem=undertow/configuration=filter/mod-cluster=*")
@ResourceType(value="mod-cluster")
public class ModCluster<T extends ModCluster<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ModClusterResources subresources = new ModClusterResources();
    @AttributeDocumentation(value="The frequency (in milliseconds) that mod-cluster advertises itself on the network")
    private Integer advertiseFrequency;
    @AttributeDocumentation(value="The path that mod-cluster is registered under.")
    private String advertisePath;
    @AttributeDocumentation(value="The protocol that is in use.")
    private String advertiseProtocol;
    @AttributeDocumentation(value="The multicast group and port that is used to advertise.")
    private String advertiseSocketBinding;
    @AttributeDocumentation(value="The amount of time that must elapse before a broken node is removed from the table")
    private Integer brokenNodeTimeout;
    @AttributeDocumentation(value="The number of connections that will be kept alive indefinitely")
    private Integer cachedConnectionsPerThread;
    @AttributeDocumentation(value="The amount of time a connection can be idle before it will be closed. Connections will not time out once the pool size is down to the configured minimum (as configured by cached-connections-per-thread)")
    private Integer connectionIdleTimeout;
    @AttributeDocumentation(value="The number of connections that will be maintained to backend servers, per IO thread.")
    private Integer connectionsPerThread;
    @AttributeDocumentation(value="If the load balancer should attempt to upgrade back end connections to HTTP2. If HTTP2 is not supported HTTP or HTTPS will be used as normal")
    private Boolean enableHttp2;
    @AttributeDocumentation(value="Determines how a failover node is chosen, in the event that the node to which a session has affinity is not available.")
    private FailoverStrategy failoverStrategy;
    @AttributeDocumentation(value="The frequency of health check pings to backend nodes")
    private Integer healthCheckInterval;
    @AttributeDocumentation(value="If push should be enabled for HTTP/2 connections")
    private Boolean http2EnablePush;
    @AttributeDocumentation(value="The size of the header table used for HPACK compression, in bytes. This amount of memory will be allocated per connection for compression. Larger values use more memory but may give better compression.")
    private Integer http2HeaderTableSize;
    @AttributeDocumentation(value="The flow control window size that controls how quickly the client can send data to the server")
    private Integer http2InitialWindowSize;
    @AttributeDocumentation(value="The maximum number of HTTP/2 streams that can be active at any time on a single connection")
    private Integer http2MaxConcurrentStreams;
    @AttributeDocumentation(value="The max HTTP/2 frame size")
    private Integer http2MaxFrameSize;
    @AttributeDocumentation(value="The maximum size of request headers the server is prepared to accept")
    private Integer http2MaxHeaderListSize;
    @AttributeDocumentation(value="A predicate that is applied to incoming requests to determine if they can perform mod cluster management commands. Provides additional security on top of what is provided by limiting management to requests that originate from the management-socket-binding")
    private String managementAccessPredicate;
    @AttributeDocumentation(value="The socket binding of the mod_cluster management address and port. When using mod_cluster two HTTP listeners should be defined, a public one to handle requests, and one bound to the internal network to handle mod cluster commands. This socket binding should correspond to the internal listener, and should not be publicly accessible.")
    private String managementSocketBinding;
    @AttributeDocumentation(value="The maximum size for AJP packets. Increasing this will allow AJP to work for requests/responses that have a large amount of headers. This is an advanced option, and must be the same between load balancers and backend servers.")
    private Integer maxAjpPacketSize;
    @AttributeDocumentation(value="The max amount of time that a request to a backend node can take before it is killed")
    private Integer maxRequestTime;
    @AttributeDocumentation(value="The number of times to attempt to retry a request if it fails. Note that if a request is not considered idempotent then it will only be retried if the proxy can be sure it was not sent to the backend server).")
    private Integer maxRetries;
    @AttributeDocumentation(value="The number of requests that can be queued if the connection pool is full before requests are rejected with a 503")
    private Integer requestQueueSize;
    @AttributeDocumentation(value="The security key that is used for the mod-cluster group. All members must use the same security key.")
    private String securityKey;
    @AttributeDocumentation(value="The security realm that provides the SSL configuration")
    private String securityRealm;
    @AttributeDocumentation(value="Reference to the SSLContext to be used by this filter.")
    private String sslContext;
    @AttributeDocumentation(value="If an alias check is performed")
    private Boolean useAlias;
    @AttributeDocumentation(value="The XNIO worker that is used to send the advertise notifications")
    private String worker;

    public ModCluster(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ModClusterResources subresources() {
        return this.subresources;
    }

    public T balancers(List<Balancer> value) {
        this.subresources.balancers = value;
        return (T)this;
    }

    public T balancer(Balancer value) {
        this.subresources.balancers.add(value);
        return (T)this;
    }

    public T balancer(String childKey, BalancerConsumer consumer) {
        Balancer child = new Balancer(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.balancer(child);
        return (T)this;
    }

    public T balancer(String childKey) {
        this.balancer(childKey, null);
        return (T)this;
    }

    public T balancer(BalancerSupplier supplier) {
        this.balancer(supplier.get());
        return (T)this;
    }

    public T singleAffinity(SingleAffinity value) {
        this.subresources.singleAffinity = value;
        return (T)this;
    }

    public T singleAffinity(SingleAffinityConsumer consumer) {
        SingleAffinity child = new SingleAffinity();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.singleAffinity = child;
        return (T)this;
    }

    public T singleAffinity() {
        SingleAffinity child = new SingleAffinity();
        this.subresources.singleAffinity = child;
        return (T)this;
    }

    public T singleAffinity(SingleAffinitySupplier supplier) {
        this.subresources.singleAffinity = supplier.get();
        return (T)this;
    }

    public T rankedAffinity(RankedAffinity value) {
        this.subresources.rankedAffinity = value;
        return (T)this;
    }

    public T rankedAffinity(RankedAffinityConsumer consumer) {
        RankedAffinity child = new RankedAffinity();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.rankedAffinity = child;
        return (T)this;
    }

    public T rankedAffinity() {
        RankedAffinity child = new RankedAffinity();
        this.subresources.rankedAffinity = child;
        return (T)this;
    }

    public T rankedAffinity(RankedAffinitySupplier supplier) {
        this.subresources.rankedAffinity = supplier.get();
        return (T)this;
    }

    public T noneAffinity(NoneAffinity value) {
        this.subresources.noneAffinity = value;
        return (T)this;
    }

    public T noneAffinity(NoneAffinityConsumer consumer) {
        NoneAffinity child = new NoneAffinity();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.noneAffinity = child;
        return (T)this;
    }

    public T noneAffinity() {
        NoneAffinity child = new NoneAffinity();
        this.subresources.noneAffinity = child;
        return (T)this;
    }

    public T noneAffinity(NoneAffinitySupplier supplier) {
        this.subresources.noneAffinity = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-frequency")
    public Integer advertiseFrequency() {
        return this.advertiseFrequency;
    }

    public T advertiseFrequency(Integer value) {
        Integer oldValue = this.advertiseFrequency;
        this.advertiseFrequency = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseFrequency", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-path")
    public String advertisePath() {
        return this.advertisePath;
    }

    public T advertisePath(String value) {
        String oldValue = this.advertisePath;
        this.advertisePath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertisePath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-protocol")
    public String advertiseProtocol() {
        return this.advertiseProtocol;
    }

    public T advertiseProtocol(String value) {
        String oldValue = this.advertiseProtocol;
        this.advertiseProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-socket-binding")
    public String advertiseSocketBinding() {
        return this.advertiseSocketBinding;
    }

    public T advertiseSocketBinding(String value) {
        String oldValue = this.advertiseSocketBinding;
        this.advertiseSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="broken-node-timeout")
    public Integer brokenNodeTimeout() {
        return this.brokenNodeTimeout;
    }

    public T brokenNodeTimeout(Integer value) {
        Integer oldValue = this.brokenNodeTimeout;
        this.brokenNodeTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("brokenNodeTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cached-connections-per-thread")
    public Integer cachedConnectionsPerThread() {
        return this.cachedConnectionsPerThread;
    }

    public T cachedConnectionsPerThread(Integer value) {
        Integer oldValue = this.cachedConnectionsPerThread;
        this.cachedConnectionsPerThread = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cachedConnectionsPerThread", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-idle-timeout")
    public Integer connectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public T connectionIdleTimeout(Integer value) {
        Integer oldValue = this.connectionIdleTimeout;
        this.connectionIdleTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionIdleTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connections-per-thread")
    public Integer connectionsPerThread() {
        return this.connectionsPerThread;
    }

    public T connectionsPerThread(Integer value) {
        Integer oldValue = this.connectionsPerThread;
        this.connectionsPerThread = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionsPerThread", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-http2")
    public Boolean enableHttp2() {
        return this.enableHttp2;
    }

    public T enableHttp2(Boolean value) {
        Boolean oldValue = this.enableHttp2;
        this.enableHttp2 = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableHttp2", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="failover-strategy")
    public FailoverStrategy failoverStrategy() {
        return this.failoverStrategy;
    }

    public T failoverStrategy(FailoverStrategy value) {
        FailoverStrategy oldValue = this.failoverStrategy;
        this.failoverStrategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("failoverStrategy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="health-check-interval")
    public Integer healthCheckInterval() {
        return this.healthCheckInterval;
    }

    public T healthCheckInterval(Integer value) {
        Integer oldValue = this.healthCheckInterval;
        this.healthCheckInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("healthCheckInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-enable-push")
    public Boolean http2EnablePush() {
        return this.http2EnablePush;
    }

    public T http2EnablePush(Boolean value) {
        Boolean oldValue = this.http2EnablePush;
        this.http2EnablePush = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2EnablePush", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-header-table-size")
    public Integer http2HeaderTableSize() {
        return this.http2HeaderTableSize;
    }

    public T http2HeaderTableSize(Integer value) {
        Integer oldValue = this.http2HeaderTableSize;
        this.http2HeaderTableSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2HeaderTableSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-initial-window-size")
    public Integer http2InitialWindowSize() {
        return this.http2InitialWindowSize;
    }

    public T http2InitialWindowSize(Integer value) {
        Integer oldValue = this.http2InitialWindowSize;
        this.http2InitialWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2InitialWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-concurrent-streams")
    public Integer http2MaxConcurrentStreams() {
        return this.http2MaxConcurrentStreams;
    }

    public T http2MaxConcurrentStreams(Integer value) {
        Integer oldValue = this.http2MaxConcurrentStreams;
        this.http2MaxConcurrentStreams = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxConcurrentStreams", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-frame-size")
    public Integer http2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    public T http2MaxFrameSize(Integer value) {
        Integer oldValue = this.http2MaxFrameSize;
        this.http2MaxFrameSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxFrameSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-header-list-size")
    public Integer http2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    public T http2MaxHeaderListSize(Integer value) {
        Integer oldValue = this.http2MaxHeaderListSize;
        this.http2MaxHeaderListSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxHeaderListSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-access-predicate")
    public String managementAccessPredicate() {
        return this.managementAccessPredicate;
    }

    public T managementAccessPredicate(String value) {
        String oldValue = this.managementAccessPredicate;
        this.managementAccessPredicate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("managementAccessPredicate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-socket-binding")
    public String managementSocketBinding() {
        return this.managementSocketBinding;
    }

    public T managementSocketBinding(String value) {
        String oldValue = this.managementSocketBinding;
        this.managementSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("managementSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-ajp-packet-size")
    public Integer maxAjpPacketSize() {
        return this.maxAjpPacketSize;
    }

    public T maxAjpPacketSize(Integer value) {
        Integer oldValue = this.maxAjpPacketSize;
        this.maxAjpPacketSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxAjpPacketSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-request-time")
    public Integer maxRequestTime() {
        return this.maxRequestTime;
    }

    public T maxRequestTime(Integer value) {
        Integer oldValue = this.maxRequestTime;
        this.maxRequestTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRequestTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-retries")
    public Integer maxRetries() {
        return this.maxRetries;
    }

    public T maxRetries(Integer value) {
        Integer oldValue = this.maxRetries;
        this.maxRetries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRetries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public T requestQueueSize(Integer value) {
        Integer oldValue = this.requestQueueSize;
        this.requestQueueSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestQueueSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-key")
    public String securityKey() {
        return this.securityKey;
    }

    public T securityKey(String value) {
        String oldValue = this.securityKey;
        this.securityKey = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityKey", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    @Deprecated
    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-context")
    public String sslContext() {
        return this.sslContext;
    }

    public T sslContext(String value) {
        String oldValue = this.sslContext;
        this.sslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-alias")
    public Boolean useAlias() {
        return this.useAlias;
    }

    public T useAlias(Boolean value) {
        Boolean oldValue = this.useAlias;
        this.useAlias = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useAlias", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public T worker(String value) {
        String oldValue = this.worker;
        this.worker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("worker", oldValue, value);
        }
        return (T)this;
    }

    public static enum FailoverStrategy {
        LOAD_BALANCED("LOAD_BALANCED"),
        DETERMINISTIC("DETERMINISTIC");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private FailoverStrategy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class ModClusterResources {
        @ResourceDocumentation(value="Runtime representation of a mod_cluster balancer")
        @SubresourceInfo(value="balancer")
        private List<Balancer> balancers = new ArrayList<Balancer>();
        @SingletonResource
        @ResourceDocumentation(value="Web requests have an affinity for the member that last handled a given session. This option corresponds to traditional sticky session behavior.")
        private SingleAffinity singleAffinity;
        @SingletonResource
        @ResourceDocumentation(value="Web requests will have an affinity for the first available node in a list typically comprised of: primary owner, backup nodes, local node (if not a primary nor backup owner).")
        private RankedAffinity rankedAffinity;
        @SingletonResource
        @ResourceDocumentation(value="Web requests will not have an affinity for any particular server, routing information will be ignored. Intended for use cases where web session state is not maintained within the application server.")
        private NoneAffinity noneAffinity;

        @Subresource
        public List<Balancer> balancers() {
            return this.balancers;
        }

        public Balancer balancer(String key) {
            return this.balancers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public SingleAffinity singleAffinity() {
            return this.singleAffinity;
        }

        @Subresource
        public RankedAffinity rankedAffinity() {
            return this.rankedAffinity;
        }

        @Subresource
        public NoneAffinity noneAffinity() {
            return this.noneAffinity;
        }
    }
}

