/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.server.host.AccessLogSetting;
import org.wildfly.swarm.config.undertow.server.host.AccessLogSettingConsumer;
import org.wildfly.swarm.config.undertow.server.host.AccessLogSettingSupplier;
import org.wildfly.swarm.config.undertow.server.host.ConsoleAccessLogSetting;
import org.wildfly.swarm.config.undertow.server.host.ConsoleAccessLogSettingConsumer;
import org.wildfly.swarm.config.undertow.server.host.ConsoleAccessLogSettingSupplier;
import org.wildfly.swarm.config.undertow.server.host.FilterRef;
import org.wildfly.swarm.config.undertow.server.host.FilterRefConsumer;
import org.wildfly.swarm.config.undertow.server.host.FilterRefSupplier;
import org.wildfly.swarm.config.undertow.server.host.HTTPInvokerSetting;
import org.wildfly.swarm.config.undertow.server.host.HTTPInvokerSettingConsumer;
import org.wildfly.swarm.config.undertow.server.host.HTTPInvokerSettingSupplier;
import org.wildfly.swarm.config.undertow.server.host.Location;
import org.wildfly.swarm.config.undertow.server.host.LocationConsumer;
import org.wildfly.swarm.config.undertow.server.host.LocationSupplier;
import org.wildfly.swarm.config.undertow.server.host.SingleSignOnSetting;
import org.wildfly.swarm.config.undertow.server.host.SingleSignOnSettingConsumer;
import org.wildfly.swarm.config.undertow.server.host.SingleSignOnSettingSupplier;

@Address(value="/subsystem=undertow/server=*/host=*")
@ResourceType(value="host")
public class Host<T extends Host<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private HostResources subresources = new HostResources();
    @AttributeDocumentation(value="Aliases for the host")
    private List<String> alias;
    @AttributeDocumentation(value="If set, this will be response code sent back in case requested context does not exist on server.")
    private Integer defaultResponseCode;
    @AttributeDocumentation(value="Default web module")
    private String defaultWebModule;
    @AttributeDocumentation(value="if set to true, /console redirect wont be enabled for this host, default is false")
    private Boolean disableConsoleRedirect;
    @AttributeDocumentation(value="If requests should be queued on start for this host. If this is set to false the default response code will be returned instead.")
    private Boolean queueRequestsOnStart;

    public Host(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public HostResources subresources() {
        return this.subresources;
    }

    public T filterRefs(List<FilterRef> value) {
        this.subresources.filterRefs = value;
        return (T)this;
    }

    public T filterRef(FilterRef value) {
        this.subresources.filterRefs.add(value);
        return (T)this;
    }

    public T filterRef(String childKey, FilterRefConsumer consumer) {
        FilterRef child = new FilterRef(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.filterRef(child);
        return (T)this;
    }

    public T filterRef(String childKey) {
        this.filterRef(childKey, null);
        return (T)this;
    }

    public T filterRef(FilterRefSupplier supplier) {
        this.filterRef(supplier.get());
        return (T)this;
    }

    public T locations(List<Location> value) {
        this.subresources.locations = value;
        return (T)this;
    }

    public T location(Location value) {
        this.subresources.locations.add(value);
        return (T)this;
    }

    public T location(String childKey, LocationConsumer consumer) {
        Location child = new Location(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.location(child);
        return (T)this;
    }

    public T location(String childKey) {
        this.location(childKey, null);
        return (T)this;
    }

    public T location(LocationSupplier supplier) {
        this.location(supplier.get());
        return (T)this;
    }

    public T accessLogSetting(AccessLogSetting value) {
        this.subresources.accessLogSetting = value;
        return (T)this;
    }

    public T accessLogSetting(AccessLogSettingConsumer consumer) {
        AccessLogSetting child = new AccessLogSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.accessLogSetting = child;
        return (T)this;
    }

    public T accessLogSetting() {
        AccessLogSetting child = new AccessLogSetting();
        this.subresources.accessLogSetting = child;
        return (T)this;
    }

    public T accessLogSetting(AccessLogSettingSupplier supplier) {
        this.subresources.accessLogSetting = supplier.get();
        return (T)this;
    }

    public T consoleAccessLogSetting(ConsoleAccessLogSetting value) {
        this.subresources.consoleAccessLogSetting = value;
        return (T)this;
    }

    public T consoleAccessLogSetting(ConsoleAccessLogSettingConsumer consumer) {
        ConsoleAccessLogSetting child = new ConsoleAccessLogSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.consoleAccessLogSetting = child;
        return (T)this;
    }

    public T consoleAccessLogSetting() {
        ConsoleAccessLogSetting child = new ConsoleAccessLogSetting();
        this.subresources.consoleAccessLogSetting = child;
        return (T)this;
    }

    public T consoleAccessLogSetting(ConsoleAccessLogSettingSupplier supplier) {
        this.subresources.consoleAccessLogSetting = supplier.get();
        return (T)this;
    }

    public T singleSignOnSetting(SingleSignOnSetting value) {
        this.subresources.singleSignOnSetting = value;
        return (T)this;
    }

    public T singleSignOnSetting(SingleSignOnSettingConsumer consumer) {
        SingleSignOnSetting child = new SingleSignOnSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.singleSignOnSetting = child;
        return (T)this;
    }

    public T singleSignOnSetting() {
        SingleSignOnSetting child = new SingleSignOnSetting();
        this.subresources.singleSignOnSetting = child;
        return (T)this;
    }

    public T singleSignOnSetting(SingleSignOnSettingSupplier supplier) {
        this.subresources.singleSignOnSetting = supplier.get();
        return (T)this;
    }

    public T httpInvokerSetting(HTTPInvokerSetting value) {
        this.subresources.httpInvokerSetting = value;
        return (T)this;
    }

    public T httpInvokerSetting(HTTPInvokerSettingConsumer consumer) {
        HTTPInvokerSetting child = new HTTPInvokerSetting();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.httpInvokerSetting = child;
        return (T)this;
    }

    public T httpInvokerSetting() {
        HTTPInvokerSetting child = new HTTPInvokerSetting();
        this.subresources.httpInvokerSetting = child;
        return (T)this;
    }

    public T httpInvokerSetting(HTTPInvokerSettingSupplier supplier) {
        this.subresources.httpInvokerSetting = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="alias")
    public List<String> alias() {
        return this.alias;
    }

    public T alias(List<String> value) {
        List<String> oldValue = this.alias;
        this.alias = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("alias", oldValue, value);
        }
        return (T)this;
    }

    public T alias(String value) {
        if (this.alias == null) {
            this.alias = new ArrayList<String>();
        }
        this.alias.add(value);
        return (T)this;
    }

    public T alias(String ... args) {
        this.alias(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-response-code")
    public Integer defaultResponseCode() {
        return this.defaultResponseCode;
    }

    public T defaultResponseCode(Integer value) {
        Integer oldValue = this.defaultResponseCode;
        this.defaultResponseCode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultResponseCode", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-web-module")
    public String defaultWebModule() {
        return this.defaultWebModule;
    }

    public T defaultWebModule(String value) {
        String oldValue = this.defaultWebModule;
        this.defaultWebModule = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultWebModule", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disable-console-redirect")
    public Boolean disableConsoleRedirect() {
        return this.disableConsoleRedirect;
    }

    public T disableConsoleRedirect(Boolean value) {
        Boolean oldValue = this.disableConsoleRedirect;
        this.disableConsoleRedirect = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disableConsoleRedirect", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-requests-on-start")
    public Boolean queueRequestsOnStart() {
        return this.queueRequestsOnStart;
    }

    public T queueRequestsOnStart(Boolean value) {
        Boolean oldValue = this.queueRequestsOnStart;
        this.queueRequestsOnStart = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueRequestsOnStart", oldValue, value);
        }
        return (T)this;
    }

    public static class HostResources {
        @ResourceDocumentation(value="Reference to filter")
        @SubresourceInfo(value="filterRef")
        private List<FilterRef> filterRefs = new ArrayList<FilterRef>();
        @ResourceDocumentation(value="Holds configuration of location resource")
        @SubresourceInfo(value="location")
        private List<Location> locations = new ArrayList<Location>();
        @SingletonResource
        @ResourceDocumentation(value="The access log configuration for this virtual server.")
        private AccessLogSetting accessLogSetting;
        @SingletonResource
        @ResourceDocumentation(value="Allows the access log to be written to the console.")
        private ConsoleAccessLogSetting consoleAccessLogSetting;
        @SingletonResource
        @ResourceDocumentation(value="An SSO authentication mechanism configuration.")
        private SingleSignOnSetting singleSignOnSetting;
        @SingletonResource
        @ResourceDocumentation(value="The HTTP invoker services that allows remote HTTP based invocation of services such as EJB and naming")
        private HTTPInvokerSetting httpInvokerSetting;

        @Subresource
        public List<FilterRef> filterRefs() {
            return this.filterRefs;
        }

        public FilterRef filterRef(String key) {
            return this.filterRefs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Location> locations() {
            return this.locations;
        }

        public Location location(String key) {
            return this.locations.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public AccessLogSetting accessLogSetting() {
            return this.accessLogSetting;
        }

        @Subresource
        public ConsoleAccessLogSetting consoleAccessLogSetting() {
            return this.consoleAccessLogSetting;
        }

        @Subresource
        public SingleSignOnSetting singleSignOnSetting() {
            return this.singleSignOnSetting;
        }

        @Subresource
        public HTTPInvokerSetting httpInvokerSetting() {
            return this.httpInvokerSetting;
        }
    }
}

