/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=undertow/server=*/https-listener=*")
@ResourceType(value="https-listener")
public class HttpsListener<T extends HttpsListener<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If a request comes in with encoded / characters (i.e. %2F), will these be decoded.")
    private Boolean allowEncodedSlash;
    @AttributeDocumentation(value="If this is true then Undertow will allow non-escaped equals characters in unquoted cookie values. Unquoted cookie values may not contain equals characters. If present the value ends before the equals sign. The remainder of the cookie value will be dropped.")
    private Boolean allowEqualsInCookieValue;
    @AttributeDocumentation(value="If this is true Undertow will accept non-encoded characters that are disallowed by the URI specification. This defaults to false, and in general should not be needed as most clients correctly encode characters. Note that setting this to true can be considered a security risk, as allowing non-standard characters can allow request smuggling attacks in some circumstances.")
    private Boolean allowUnescapedCharactersInUrl;
    @AttributeDocumentation(value="If this is true then a Connection: keep-alive header will be added to responses, even when it is not strictly required by the specification.")
    private Boolean alwaysSetKeepAlive;
    @AttributeDocumentation(value="If we should buffer pipelined requests.")
    private Boolean bufferPipelinedData;
    @AttributeDocumentation(value="The listeners buffer pool")
    private String bufferPool;
    @AttributeDocumentation(value="The number of bytes that have been received by this listener")
    private Long bytesReceived;
    @AttributeDocumentation(value="The number of bytes that have been sent out on this listener")
    private Long bytesSent;
    @AttributeDocumentation(value="If certificate forwarding should be enabled. If this is enabled then the listener will take the certificate from the SSL_CLIENT_CERT attribute. This should only be enabled if behind a proxy, and the proxy is configured to always set these headers.")
    private Boolean certificateForwarding;
    @AttributeDocumentation(value="If this is true then the parser will decode the URL and query parameters using the selected character encoding (UTF-8 by default). If this is false they will not be decoded. This will allow a later handler to decode them into whatever charset is desired.")
    private Boolean decodeUrl;
    @AttributeDocumentation(value="A comma separated list of HTTP methods that are not allowed")
    private List<String> disallowedMethods;
    @AttributeDocumentation(value="Enables HTTP2 support for this listener")
    private Boolean enableHttp2;
    @AttributeDocumentation(value="Enables SPDY support for this listener. This has been deprecated and has no effect, HTTP/2 should be used instead")
    private Boolean enableSpdy;
    @AttributeDocumentation(value="If the listener is enabled")
    private Boolean enabled;
    @AttributeDocumentation(value="Configures Enabled SSL ciphers")
    private String enabledCipherSuites;
    @AttributeDocumentation(value="Configures SSL protocols")
    private String enabledProtocols;
    @AttributeDocumentation(value="The number of 500 responses that have been sent by this listener")
    private Long errorCount;
    @AttributeDocumentation(value="If server push is enabled for this connection")
    private Boolean http2EnablePush;
    @AttributeDocumentation(value="The size of the header table used for HPACK compression, in bytes. This amount of memory will be allocated per connection for compression. Larger values use more memory but may give better compression.")
    private Integer http2HeaderTableSize;
    @AttributeDocumentation(value="The flow control window size that controls how quickly the client can send data to the server")
    private Integer http2InitialWindowSize;
    @AttributeDocumentation(value="The maximum number of HTTP/2 streams that can be active at any time on a single connection")
    private Integer http2MaxConcurrentStreams;
    @AttributeDocumentation(value="The max HTTP/2 frame size")
    private Integer http2MaxFrameSize;
    @AttributeDocumentation(value="The maximum size of request headers the server is prepared to accept")
    private Integer http2MaxHeaderListSize;
    @AttributeDocumentation(value="Maximum size of a buffered request, in bytes. Requests are not usually buffered, the most common case is when performing SSL renegotiation for a POST request, and the post data must be fully buffered in order to perform the renegotiation.")
    private Integer maxBufferedRequestSize;
    @AttributeDocumentation(value="The maximum number of concurrent connections. Only values greater than 0 are allowed. For unlimited connections simply undefine this attribute value.")
    private Integer maxConnections;
    @AttributeDocumentation(value="The maximum number of cookies that will be parsed. This is used to protect against hash vulnerabilities.")
    private Integer maxCookies;
    @AttributeDocumentation(value="The maximum size of a http request header, in bytes.")
    private Integer maxHeaderSize;
    @AttributeDocumentation(value="The maximum number of headers that will be parsed. This is used to protect against hash vulnerabilities.")
    private Integer maxHeaders;
    @AttributeDocumentation(value="The maximum number of parameters that will be parsed. This is used to protect against hash vulnerabilities. This applies to both query parameters, and to POST data, but is not cumulative (i.e. you can potentially have max parameters * 2 total parameters).")
    private Integer maxParameters;
    @AttributeDocumentation(value="The maximum size of a post that will be accepted, in bytes.")
    private Long maxPostSize;
    @AttributeDocumentation(value="The maximum processing time taken by a request on this listener")
    private Long maxProcessingTime;
    @AttributeDocumentation(value="The length of time in milliseconds that the connection can be idle before it is closed by the container.")
    private Integer noRequestTimeout;
    @AttributeDocumentation(value="The total processing time of all requests handed by this listener")
    private Long processingTime;
    @AttributeDocumentation(value="Enables  handling of x-forwarded-host header (and other x-forwarded-* headers) and use this header information to set the remote address. This should only be used behind a trusted proxy that sets these headers otherwise a remote user can spoof their IP address.")
    private Boolean proxyAddressForwarding;
    @AttributeDocumentation(value="If this is true then the listener will use the proxy protocol v1, as defined by https://www.haproxy.org/download/1.8/doc/proxy-protocol.txt. This option MUST only be enabled for listeners that are behind a load balancer that supports the same protocol.")
    private Boolean proxyProtocol;
    @AttributeDocumentation(value="Configure a read timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful read taking place, the socket's next read will throw a {@link ReadTimeoutException}.")
    private Integer readTimeout;
    @AttributeDocumentation(value="The receive buffer size, in bytes.")
    private Integer receiveBuffer;
    @AttributeDocumentation(value="If this is true then Undertow will record the request start time, to allow for request time to be logged. This has a small but measurable performance impact")
    private Boolean recordRequestStartTime;
    @AttributeDocumentation(value="The number of requests this listener has served")
    private Long requestCount;
    @AttributeDocumentation(value="The maximum amount of time (in milliseconds) that can be spent parsing the request")
    private Integer requestParseTimeout;
    @AttributeDocumentation(value="Require that all HTTP/1.1 requests have a 'Host' header, as per the RFC. IF the request does not include this header it will be rejected with a 403.")
    private Boolean requireHostHttp11;
    @AttributeDocumentation(value="Enables host dns lookup")
    private Boolean resolvePeerAddress;
    @AttributeDocumentation(value="If cookies should be validated to ensure they comply with RFC6265.")
    private Boolean rfc6265CookieValidation;
    @AttributeDocumentation(value="If this is true then requests that originate from this listener are marked as secure, even if the request is not using HTTPS.")
    private Boolean secure;
    @AttributeDocumentation(value="The listeners security realm")
    private String securityRealm;
    @AttributeDocumentation(value="The send buffer size, in bytes.")
    private Integer sendBuffer;
    @AttributeDocumentation(value="The listener socket binding")
    private String socketBinding;
    @AttributeDocumentation(value="Reference to the SSLContext to be used by this listener.")
    private String sslContext;
    @AttributeDocumentation(value="The maximum number of active SSL sessions")
    private Integer sslSessionCacheSize;
    @AttributeDocumentation(value="The timeout for SSL sessions, in seconds")
    private Integer sslSessionTimeout;
    @AttributeDocumentation(value="Configure a server with the specified backlog.")
    private Integer tcpBacklog;
    @AttributeDocumentation(value="Configure a channel to send TCP keep-alive messages in an implementation-dependent manner.")
    private Boolean tcpKeepAlive;
    @AttributeDocumentation(value="URL charset")
    private String urlCharset;
    @AttributeDocumentation(value="The desired SSL client authentication mode for SSL channels")
    private String verifyClient;
    @AttributeDocumentation(value="The listeners XNIO worker")
    private String worker;
    @AttributeDocumentation(value="Configure a write timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful write taking place, the socket's next write will throw a {@link WriteTimeoutException}.")
    private Integer writeTimeout;

    public HttpsListener(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allow-encoded-slash")
    public Boolean allowEncodedSlash() {
        return this.allowEncodedSlash;
    }

    public T allowEncodedSlash(Boolean value) {
        Boolean oldValue = this.allowEncodedSlash;
        this.allowEncodedSlash = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowEncodedSlash", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-equals-in-cookie-value")
    public Boolean allowEqualsInCookieValue() {
        return this.allowEqualsInCookieValue;
    }

    public T allowEqualsInCookieValue(Boolean value) {
        Boolean oldValue = this.allowEqualsInCookieValue;
        this.allowEqualsInCookieValue = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowEqualsInCookieValue", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-unescaped-characters-in-url")
    public Boolean allowUnescapedCharactersInUrl() {
        return this.allowUnescapedCharactersInUrl;
    }

    public T allowUnescapedCharactersInUrl(Boolean value) {
        Boolean oldValue = this.allowUnescapedCharactersInUrl;
        this.allowUnescapedCharactersInUrl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowUnescapedCharactersInUrl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="always-set-keep-alive")
    public Boolean alwaysSetKeepAlive() {
        return this.alwaysSetKeepAlive;
    }

    public T alwaysSetKeepAlive(Boolean value) {
        Boolean oldValue = this.alwaysSetKeepAlive;
        this.alwaysSetKeepAlive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("alwaysSetKeepAlive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-pipelined-data")
    public Boolean bufferPipelinedData() {
        return this.bufferPipelinedData;
    }

    public T bufferPipelinedData(Boolean value) {
        Boolean oldValue = this.bufferPipelinedData;
        this.bufferPipelinedData = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferPipelinedData", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-pool")
    public String bufferPool() {
        return this.bufferPool;
    }

    public T bufferPool(String value) {
        String oldValue = this.bufferPool;
        this.bufferPool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferPool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="bytes-received")
    public Long bytesReceived() {
        return this.bytesReceived;
    }

    public T bytesReceived(Long value) {
        Long oldValue = this.bytesReceived;
        this.bytesReceived = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bytesReceived", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="bytes-sent")
    public Long bytesSent() {
        return this.bytesSent;
    }

    public T bytesSent(Long value) {
        Long oldValue = this.bytesSent;
        this.bytesSent = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bytesSent", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="certificate-forwarding")
    public Boolean certificateForwarding() {
        return this.certificateForwarding;
    }

    public T certificateForwarding(Boolean value) {
        Boolean oldValue = this.certificateForwarding;
        this.certificateForwarding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("certificateForwarding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="decode-url")
    public Boolean decodeUrl() {
        return this.decodeUrl;
    }

    public T decodeUrl(Boolean value) {
        Boolean oldValue = this.decodeUrl;
        this.decodeUrl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("decodeUrl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disallowed-methods")
    public List<String> disallowedMethods() {
        return this.disallowedMethods;
    }

    public T disallowedMethods(List<String> value) {
        List<String> oldValue = this.disallowedMethods;
        this.disallowedMethods = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disallowedMethods", oldValue, value);
        }
        return (T)this;
    }

    public T disallowedMethod(String value) {
        if (this.disallowedMethods == null) {
            this.disallowedMethods = new ArrayList<String>();
        }
        this.disallowedMethods.add(value);
        return (T)this;
    }

    public T disallowedMethods(String ... args) {
        this.disallowedMethods(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-http2")
    public Boolean enableHttp2() {
        return this.enableHttp2;
    }

    public T enableHttp2(Boolean value) {
        Boolean oldValue = this.enableHttp2;
        this.enableHttp2 = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableHttp2", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="enable-spdy")
    public Boolean enableSpdy() {
        return this.enableSpdy;
    }

    @Deprecated
    public T enableSpdy(Boolean value) {
        Boolean oldValue = this.enableSpdy;
        this.enableSpdy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableSpdy", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    @Deprecated
    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="enabled-cipher-suites")
    public String enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Deprecated
    public T enabledCipherSuites(String value) {
        String oldValue = this.enabledCipherSuites;
        this.enabledCipherSuites = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabledCipherSuites", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="enabled-protocols")
    public String enabledProtocols() {
        return this.enabledProtocols;
    }

    @Deprecated
    public T enabledProtocols(String value) {
        String oldValue = this.enabledProtocols;
        this.enabledProtocols = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabledProtocols", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="error-count")
    public Long errorCount() {
        return this.errorCount;
    }

    public T errorCount(Long value) {
        Long oldValue = this.errorCount;
        this.errorCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("errorCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-enable-push")
    public Boolean http2EnablePush() {
        return this.http2EnablePush;
    }

    public T http2EnablePush(Boolean value) {
        Boolean oldValue = this.http2EnablePush;
        this.http2EnablePush = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2EnablePush", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-header-table-size")
    public Integer http2HeaderTableSize() {
        return this.http2HeaderTableSize;
    }

    public T http2HeaderTableSize(Integer value) {
        Integer oldValue = this.http2HeaderTableSize;
        this.http2HeaderTableSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2HeaderTableSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-initial-window-size")
    public Integer http2InitialWindowSize() {
        return this.http2InitialWindowSize;
    }

    public T http2InitialWindowSize(Integer value) {
        Integer oldValue = this.http2InitialWindowSize;
        this.http2InitialWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2InitialWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-concurrent-streams")
    public Integer http2MaxConcurrentStreams() {
        return this.http2MaxConcurrentStreams;
    }

    public T http2MaxConcurrentStreams(Integer value) {
        Integer oldValue = this.http2MaxConcurrentStreams;
        this.http2MaxConcurrentStreams = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxConcurrentStreams", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-frame-size")
    public Integer http2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    public T http2MaxFrameSize(Integer value) {
        Integer oldValue = this.http2MaxFrameSize;
        this.http2MaxFrameSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxFrameSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http2-max-header-list-size")
    public Integer http2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    public T http2MaxHeaderListSize(Integer value) {
        Integer oldValue = this.http2MaxHeaderListSize;
        this.http2MaxHeaderListSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("http2MaxHeaderListSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-buffered-request-size")
    public Integer maxBufferedRequestSize() {
        return this.maxBufferedRequestSize;
    }

    public T maxBufferedRequestSize(Integer value) {
        Integer oldValue = this.maxBufferedRequestSize;
        this.maxBufferedRequestSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxBufferedRequestSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-connections")
    public Integer maxConnections() {
        return this.maxConnections;
    }

    public T maxConnections(Integer value) {
        Integer oldValue = this.maxConnections;
        this.maxConnections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxConnections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-cookies")
    public Integer maxCookies() {
        return this.maxCookies;
    }

    public T maxCookies(Integer value) {
        Integer oldValue = this.maxCookies;
        this.maxCookies = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxCookies", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-header-size")
    public Integer maxHeaderSize() {
        return this.maxHeaderSize;
    }

    public T maxHeaderSize(Integer value) {
        Integer oldValue = this.maxHeaderSize;
        this.maxHeaderSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxHeaderSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-headers")
    public Integer maxHeaders() {
        return this.maxHeaders;
    }

    public T maxHeaders(Integer value) {
        Integer oldValue = this.maxHeaders;
        this.maxHeaders = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxHeaders", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-parameters")
    public Integer maxParameters() {
        return this.maxParameters;
    }

    public T maxParameters(Integer value) {
        Integer oldValue = this.maxParameters;
        this.maxParameters = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxParameters", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-post-size")
    public Long maxPostSize() {
        return this.maxPostSize;
    }

    public T maxPostSize(Long value) {
        Long oldValue = this.maxPostSize;
        this.maxPostSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPostSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-processing-time")
    public Long maxProcessingTime() {
        return this.maxProcessingTime;
    }

    public T maxProcessingTime(Long value) {
        Long oldValue = this.maxProcessingTime;
        this.maxProcessingTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxProcessingTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-request-timeout")
    public Integer noRequestTimeout() {
        return this.noRequestTimeout;
    }

    public T noRequestTimeout(Integer value) {
        Integer oldValue = this.noRequestTimeout;
        this.noRequestTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noRequestTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="processing-time")
    public Long processingTime() {
        return this.processingTime;
    }

    public T processingTime(Long value) {
        Long oldValue = this.processingTime;
        this.processingTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processingTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="proxy-address-forwarding")
    public Boolean proxyAddressForwarding() {
        return this.proxyAddressForwarding;
    }

    public T proxyAddressForwarding(Boolean value) {
        Boolean oldValue = this.proxyAddressForwarding;
        this.proxyAddressForwarding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("proxyAddressForwarding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="proxy-protocol")
    public Boolean proxyProtocol() {
        return this.proxyProtocol;
    }

    public T proxyProtocol(Boolean value) {
        Boolean oldValue = this.proxyProtocol;
        this.proxyProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("proxyProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="read-timeout")
    public Integer readTimeout() {
        return this.readTimeout;
    }

    public T readTimeout(Integer value) {
        Integer oldValue = this.readTimeout;
        this.readTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("readTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="receive-buffer")
    public Integer receiveBuffer() {
        return this.receiveBuffer;
    }

    public T receiveBuffer(Integer value) {
        Integer oldValue = this.receiveBuffer;
        this.receiveBuffer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receiveBuffer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="record-request-start-time")
    public Boolean recordRequestStartTime() {
        return this.recordRequestStartTime;
    }

    public T recordRequestStartTime(Boolean value) {
        Boolean oldValue = this.recordRequestStartTime;
        this.recordRequestStartTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recordRequestStartTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-count")
    public Long requestCount() {
        return this.requestCount;
    }

    public T requestCount(Long value) {
        Long oldValue = this.requestCount;
        this.requestCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-parse-timeout")
    public Integer requestParseTimeout() {
        return this.requestParseTimeout;
    }

    public T requestParseTimeout(Integer value) {
        Integer oldValue = this.requestParseTimeout;
        this.requestParseTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestParseTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="require-host-http11")
    public Boolean requireHostHttp11() {
        return this.requireHostHttp11;
    }

    public T requireHostHttp11(Boolean value) {
        Boolean oldValue = this.requireHostHttp11;
        this.requireHostHttp11 = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requireHostHttp11", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="resolve-peer-address")
    public Boolean resolvePeerAddress() {
        return this.resolvePeerAddress;
    }

    public T resolvePeerAddress(Boolean value) {
        Boolean oldValue = this.resolvePeerAddress;
        this.resolvePeerAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("resolvePeerAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="rfc6265-cookie-validation")
    public Boolean rfc6265CookieValidation() {
        return this.rfc6265CookieValidation;
    }

    public T rfc6265CookieValidation(Boolean value) {
        Boolean oldValue = this.rfc6265CookieValidation;
        this.rfc6265CookieValidation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("rfc6265CookieValidation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="secure")
    public Boolean secure() {
        return this.secure;
    }

    public T secure(Boolean value) {
        Boolean oldValue = this.secure;
        this.secure = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("secure", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    @Deprecated
    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="send-buffer")
    public Integer sendBuffer() {
        return this.sendBuffer;
    }

    public T sendBuffer(Integer value) {
        Integer oldValue = this.sendBuffer;
        this.sendBuffer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sendBuffer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-context")
    public String sslContext() {
        return this.sslContext;
    }

    public T sslContext(String value) {
        String oldValue = this.sslContext;
        this.sslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslContext", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="ssl-session-cache-size")
    public Integer sslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    @Deprecated
    public T sslSessionCacheSize(Integer value) {
        Integer oldValue = this.sslSessionCacheSize;
        this.sslSessionCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslSessionCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="ssl-session-timeout")
    public Integer sslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    @Deprecated
    public T sslSessionTimeout(Integer value) {
        Integer oldValue = this.sslSessionTimeout;
        this.sslSessionTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslSessionTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tcp-backlog")
    public Integer tcpBacklog() {
        return this.tcpBacklog;
    }

    public T tcpBacklog(Integer value) {
        Integer oldValue = this.tcpBacklog;
        this.tcpBacklog = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tcpBacklog", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tcp-keep-alive")
    public Boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public T tcpKeepAlive(Boolean value) {
        Boolean oldValue = this.tcpKeepAlive;
        this.tcpKeepAlive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tcpKeepAlive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-charset")
    public String urlCharset() {
        return this.urlCharset;
    }

    public T urlCharset(String value) {
        String oldValue = this.urlCharset;
        this.urlCharset = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlCharset", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="verify-client")
    public String verifyClient() {
        return this.verifyClient;
    }

    @Deprecated
    public T verifyClient(String value) {
        String oldValue = this.verifyClient;
        this.verifyClient = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("verifyClient", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public T worker(String value) {
        String oldValue = this.worker;
        this.worker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("worker", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="write-timeout")
    public Integer writeTimeout() {
        return this.writeTimeout;
    }

    public T writeTimeout(Integer value) {
        Integer oldValue = this.writeTimeout;
        this.writeTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("writeTimeout", oldValue, value);
        }
        return (T)this;
    }
}

