package org.wildfly.swarm.container.util;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-12-05T04:46:06-0700")
public class Messages_$logger extends DelegatingBasicLogger implements Messages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void attemptToAutoDetectDriver(final String driverName) {
        super.log.logf(FQCN, DEBUG, null, attemptToAutoDetectDriver$str(), driverName);
    }
    protected String attemptToAutoDetectDriver$str() {
        return "THORN1121: Attempting to auto-detect driver for %s";
    }
    @Override
    public final void autodetectedDriver(final String driverName) {
        super.log.logf(FQCN, INFO, null, autodetectedDriver$str(), driverName);
    }
    protected String autodetectedDriver$str() {
        return "THORN1122: Auto-detected driver for %s";
    }
    @Override
    public final void errorLoadingAutodetectedDriver(final String driverName, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorLoadingAutodetectedDriver$str(), driverName);
    }
    protected String errorLoadingAutodetectedDriver$str() {
        return "THORN1123: Detected driver %s, but an error occurred while loading it";
    }
    protected String cannotAddReferenceToModule$str() {
        return "THORN1124: Cannot generate new module '%s' when module '%s' is already being used by application";
    }
    @Override
    public final IllegalStateException cannotAddReferenceToModule(final String module, final String alreadyAssociatedModule) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAddReferenceToModule$str(), module, alreadyAssociatedModule));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}
