package org.wildfly.swarm.internal;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.wildfly.swarm.container.DeploymentException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-12-05T04:46:06-0700")
public class DeployerMessages_$logger extends DelegatingBasicLogger implements DeployerMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeployerMessages_$logger.class.getName();
    public DeployerMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unableToCreateDefaultDeployment$str() {
        return "TTDEPLOY0001: Unable to create default deployment.";
    }
    @Override
    public final DeploymentException unableToCreateDefaultDeployment() {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), unableToCreateDefaultDeployment$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void noDeploymentsSpecified() {
        super.log.logf(FQCN, ERROR, null, noDeploymentsSpecified$str());
    }
    protected String noDeploymentsSpecified$str() {
        return "TTDEPLOY0002: No deployments specified";
    }
    @Override
    public final void deploying(final String deploymentName) {
        super.log.logf(FQCN, DEBUG, null, deploying$str(), deploymentName);
    }
    protected String deploying$str() {
        return "TTDEPLOY0003: Deploying %s";
    }
    @Override
    public final void deploymentContent(final String path) {
        super.log.logf(FQCN, DEBUG, null, deploymentContent$str(), path);
    }
    protected String deploymentContent$str() {
        return "TTDEPLOY0004: Deployment content: %s";
    }
    @Override
    public final void exportingDeployment(final String exportLocation) {
        super.log.logf(FQCN, INFO, null, exportingDeployment$str(), exportLocation);
    }
    protected String exportingDeployment$str() {
        return "TTDEPLOY0005: Exporting deployment to %s";
    }
    protected String unableToCreateDefaultDeploymentWar$str() {
        return "TTDEPLOY0006: Unable to create default deployment of type .war, maybe missing the 'undertow' or 'jaxrs' fraction";
    }
    @Override
    public final DeploymentException unableToCreateDefaultDeploymentWar() {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), unableToCreateDefaultDeploymentWar$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
