package org.wildfly.swarm.internal;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Collection;
import org.wildfly.swarm.container.DeploymentException;
import java.util.List;
import org.wildfly.swarm.spi.api.Customizer;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-12-05T04:46:06-0700")
public class SwarmMessages_$logger extends DelegatingBasicLogger implements SwarmMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SwarmMessages_$logger.class.getName();
    public SwarmMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String containerNotStarted$str() {
        return "THORN0001: Cannot invoke %s on a container that has not been started.";
    }
    @Override
    public final IllegalStateException containerNotStarted(final String method) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), containerNotStarted$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String argumentRequired$str() {
        return "THORN0002: %s requires an argument.";
    }
    @Override
    public final RuntimeException argumentRequired(final String arg) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), argumentRequired$str(), arg));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failToMountDeployment$str() {
        return "THORN0003: Failed to mount deployment.";
    }
    @Override
    public final DeploymentException failToMountDeployment(final Throwable cause, final Archive<?> archive) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), failToMountDeployment$str()), cause, archive);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentFailed1$str() {
        return "THORN0004: Deployment failed: %s";
    }
    @Override
    public final String deploymentFailed(final String failureMessage) {
        return String.format(getLoggingLocale(), deploymentFailed1$str(), failureMessage);
    }
    protected String deploymentFailed0$str() {
        return "THORN0005: Failure during deployment";
    }
    @Override
    public final DeploymentException deploymentFailed(final Throwable cause, final Archive<?> archive) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), deploymentFailed0$str()), cause, archive);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String librariesNotSupported$str() {
        return "THORN0006: JavaArchive spec does not support Libraries";
    }
    @Override
    public final UnsupportedOperationException librariesNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), librariesNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fractionHasMultipleExtensions$str() {
        return "THORN0007: Fraction \"%s\" was configured using @WildFlyExtension with a module='', but has multiple extension classes.  Please use classname='' to specify exactly one, or noClass=true to ignore all. %s";
    }
    @Override
    public final RuntimeException fractionHasMultipleExtensions(final String className, final Collection<String> extensions) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), fractionHasMultipleExtensions$str(), className, extensions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String artifactNotFound$str() {
        return "THORN0008: Artifact '%s' not found.";
    }
    @Override
    public final RuntimeException artifactNotFound(final String gav) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), artifactNotFound$str(), gav));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDetermineVersion$str() {
        return "THORN0009: Unable to determine version number from GAV: %s";
    }
    @Override
    public final RuntimeException unableToDetermineVersion(final String gav) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToDetermineVersion$str(), gav));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String gavMinimumSegments$str() {
        return "THORN0010: GAV must includes at least 2 segments";
    }
    @Override
    public final RuntimeException gavMinimumSegments() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), gavMinimumSegments$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String systemPropertyNotFound$str() {
        return "THORN0011: System property '%s' not provided.";
    }
    @Override
    public final IllegalStateException systemPropertyNotFound(final String key) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), systemPropertyNotFound$str(), key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotIdentifyFileSystemLayout$str() {
        return "THORN0012: Cannot identify FileSystemLayout for given path: %s";
    }
    @Override
    public final IllegalArgumentException cannotIdentifyFileSystemLayout(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotIdentifyFileSystemLayout$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String availableFraction$str() {
        return "THORN0013: Installed fraction: %24s - %-15s %s:%s:%s";
    }
    @Override
    public final String availableFraction(final String name, final String stabilityLevel, final String groupId, final String artifactId, final String version) {
        return String.format(getLoggingLocale(), availableFraction$str(), name, stabilityLevel, groupId, artifactId, version);
    }
    @Override
    public final void shrinkwrapDomainSetupFailed(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, shrinkwrapDomainSetupFailed$str());
    }
    protected String shrinkwrapDomainSetupFailed$str() {
        return "THORN0014: Unable to setup Shrinkwrap Domain";
    }
    @Override
    public final void deploymentModuleAdded(final DeploymentModule module) {
        super.log.logf(FQCN, DEBUG, null, deploymentModuleAdded$str(), module);
    }
    protected String deploymentModuleAdded$str() {
        return "THORN0015: Add deployment module: %s";
    }
    @Override
    public final void callingPreCustomizer(final Customizer customizer) {
        super.log.logf(FQCN, DEBUG, null, callingPreCustomizer$str(), customizer);
    }
    protected String callingPreCustomizer$str() {
        return "THORN0016: Calling Pre Customizer: %s";
    }
    @Override
    public final void callingPostCustomizer(final Customizer customizer) {
        super.log.logf(FQCN, DEBUG, null, callingPostCustomizer$str(), customizer);
    }
    protected String callingPostCustomizer$str() {
        return "THORN0017: Calling Post Customizer: %s";
    }
    @Override
    public final void wildflyBootstrap(final String operations) {
        super.log.logf(FQCN, DEBUG, null, wildflyBootstrap$str(), operations);
    }
    protected String wildflyBootstrap$str() {
        return "THORN0018: WildFly Bootstrap operations: \n %s";
    }
    @Override
    public final void argsInstalled(final List<String> args) {
        super.log.logf(FQCN, INFO, null, argsInstalled$str(), args);
    }
    protected String argsInstalled$str() {
        return "THORN0019: Install MSC service for command line args: %s";
    }
    protected String httpsRequiresManagementFraction$str() {
        return "THORN0020: HTTP/S is configured correctly, but io.thorntail:management is not available";
    }
    @Override
    public final RuntimeException httpsRequiresManagementFraction() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), httpsRequiresManagementFraction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringSubsystem(final String nsURI, final String name) {
        super.log.logf(FQCN, WARN, null, ignoringSubsystem$str(), nsURI, name);
    }
    protected String ignoringSubsystem$str() {
        return "THORN0021: Ignoring subsystem %s:%s";
    }
    @Override
    public final void moduleMBeanServerNotInstalled(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, moduleMBeanServerNotInstalled$str());
    }
    protected String moduleMBeanServerNotInstalled$str() {
        return "THORN0022: Failed to register modules mbeans";
    }
    @Override
    public final void errorInstallingUserSpaceExtension(final String factoryClassName) {
        super.log.logf(FQCN, ERROR, null, errorInstallingUserSpaceExtension$str(), factoryClassName);
    }
    protected String errorInstallingUserSpaceExtension$str() {
        return "THORN0023: Error installing user-space CDI extension: %s";
    }
    @Override
    public final void http2NotSupported() {
        super.log.logf(FQCN, WARN, null, http2NotSupported$str());
    }
    protected String http2NotSupported$str() {
        return "THORN0024: In order to use HTTP/2 in Thorntail, you must have the OpenSSL provider with ALPN capability from JBoss Core Services installed and configured. This is due to the fact that HTTP/2 requires a TLS stack that supports ALPN, which is not provided by the default installation of Java 8. HTTP/2 will only work with browsers that also support the HTTP/2 standard. OpenSSL usage with Thorntail on HP-UX is NOT supported.";
    }
    protected String generateSelfSignedCertificateNotSupported$str() {
        return "THORN0025: This version of Thorntail does not support generating self signed certificates.";
    }
    @Override
    public final RuntimeException generateSelfSignedCertificateNotSupported() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), generateSelfSignedCertificateNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failToInvokeGenerateSelfSignedCertificateHost(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failToInvokeGenerateSelfSignedCertificateHost$str());
    }
    protected String failToInvokeGenerateSelfSignedCertificateHost$str() {
        return "THORN0026: Error invoking SslServerIdentity.generateSelfSignedCertificateHost(String) in HTTPSCustomizer.";
    }
    @Override
    public final void shutdownRequested() {
        super.log.logf(FQCN, INFO, null, shutdownRequested$str());
    }
    protected String shutdownRequested$str() {
        return "THORN0027: Shutdown requested";
    }
    @Override
    public final void errorWaitingForContainerShutdown(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorWaitingForContainerShutdown$str());
    }
    protected String errorWaitingForContainerShutdown$str() {
        return "THORN0028: Error invoking SslServerIdentity.generateSelfSignedCertificateHost(String) in HTTPSCustomizer.";
    }
    @Override
    public final void errorSettingUpTempFileProvider(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorSettingUpTempFileProvider$str());
    }
    protected String errorSettingUpTempFileProvider$str() {
        return "THORN0029: Error setting up temporary file provider.";
    }
    @Override
    public final void errorCleaningUpTempFileProvider(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorCleaningUpTempFileProvider$str());
    }
    protected String errorCleaningUpTempFileProvider$str() {
        return "THORN0030: Error cleaning up temporary file provider.";
    }
    @Override
    public final void registeredArchivePreparer(final String preparer) {
        super.log.logf(FQCN, TRACE, null, registeredArchivePreparer$str(), preparer);
    }
    protected String registeredArchivePreparer$str() {
        return "THORN0031: Registered archive-preparer: %s";
    }
    protected String invalidFileSystemLayoutProvided$str() {
        return "THORN0032: Invalid file system layout: %s";
    }
    @Override
    public final String invalidFileSystemLayoutProvided(final String message) {
        return String.format(getLoggingLocale(), invalidFileSystemLayoutProvided$str(), message);
    }
    @Override
    public final void usage(final String message) {
        super.log.logf(FQCN, INFO, null, usage$str(), message);
    }
    protected String usage$str() {
        return "THORN88888: %n%n========================================================================%n%n%s%n%n========================================================================%n";
    }
    @Override
    public final void wildflySwarmIsReady() {
        super.log.logf(FQCN, INFO, null, wildflySwarmIsReady$str());
    }
    protected String wildflySwarmIsReady$str() {
        return "THORN99999: Thorntail is Ready";
    }
}
