/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.vfs.TempFileProvider;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.bootstrap.util.BootstrapProperties;
import org.wildfly.swarm.container.DeploymentException;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContext;
import org.wildfly.swarm.container.runtime.deployments.DefaultDeploymentCreator;
import org.wildfly.swarm.container.runtime.wildfly.SwarmContentRepository;
import org.wildfly.swarm.internal.DeployerMessages;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.ArtifactLookup;
import org.wildfly.swarm.spi.api.DependenciesContainer;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.JARArchive;

@ApplicationScoped
public class RuntimeDeployer
implements Deployer {
    private static final String ALL_DEPENDENCIES_ADDED_MARKER = "org.wildfly.swarm.allDependencies.added";
    @Inject
    DeploymentContext deploymentContext;
    private String defaultDeploymentType;
    @Inject
    private ModelControllerClient client;
    @Inject
    private SwarmContentRepository contentRepository;
    @Inject
    private TempFileProvider tempFileProvider;
    @Inject
    private DefaultDeploymentCreator defaultDeploymentCreator;
    private boolean debug = false;
    @Inject
    @Any
    private Instance<DeploymentProcessor> deploymentProcessors;
    private List<String> rarDeploymentNames = new ArrayList<String>();
    private boolean implicitDeploymentsComplete = false;

    void implicitDeploymentsComplete() {
        this.implicitDeploymentsComplete = true;
    }

    @Override
    public void deploy() throws DeploymentException {
        Archive<?> deployment = this.createDefaultDeployment();
        if (deployment == null) {
            String deploymentType = this.determineDeploymentType();
            if ("war".equals(deploymentType)) {
                throw DeployerMessages.MESSAGES.unableToCreateDefaultDeploymentWar();
            }
            throw DeployerMessages.MESSAGES.unableToCreateDefaultDeployment();
        }
        this.deploy(deployment);
    }

    @Override
    public void deploy(Collection<Path> pathsToDeploy) throws DeploymentException {
        if (pathsToDeploy.isEmpty()) {
            DeployerMessages.MESSAGES.noDeploymentsSpecified();
            return;
        }
        RuntimeDeployer.archives(pathsToDeploy).forEach(e -> this.deploy((Archive<?>)e));
    }

    protected static Stream<Archive> archives(Collection<Path> paths) {
        return paths.stream().map(path -> {
            String simpleName = path.getFileName().toString();
            Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)simpleName);
            ((ZipImporter)archive.as(ZipImporter.class)).importFrom(path.toFile());
            return archive;
        });
    }

    @Override
    public Archive<?> createDefaultDeployment() {
        return this.defaultDeploymentCreator.createDefaultDeployment(this.determineDeploymentType());
    }

    private String determineDeploymentType() {
        if (this.defaultDeploymentType == null) {
            this.defaultDeploymentType = this.determineDeploymentTypeInternal();
            System.setProperty("thorntail.default.deployment.type", this.defaultDeploymentType);
        }
        return this.defaultDeploymentType;
    }

    private String determineDeploymentTypeInternal() {
        int dotLoc;
        String artifact = System.getProperty("thorntail.app.path");
        if (artifact != null && (dotLoc = artifact.lastIndexOf(46)) >= 0) {
            return artifact.substring(dotLoc + 1);
        }
        artifact = System.getProperty("thorntail.app.artifact");
        if (artifact != null && (dotLoc = artifact.lastIndexOf(46)) >= 0) {
            return artifact.substring(dotLoc + 1);
        }
        FileSystemLayout fsLayout = FileSystemLayout.create();
        return fsLayout.determinePackagingType();
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void deploy(Archive<?> deployment) throws DeploymentException {
        this.deploy(deployment, deployment.getName());
    }

    /*
     * Loose catch block
     */
    public void deploy(Archive<?> deployment, String asName) throws DeploymentException {
        if (deployment.getName().endsWith(".rar")) {
            this.rarDeploymentNames.add(deployment.getName());
        } else if (!this.rarDeploymentNames.isEmpty()) {
            JARArchive mutable = (JARArchive)deployment.as(JARArchive.class);
            this.rarDeploymentNames.forEach(e -> mutable.addModule("deployment." + e));
        }
        try {
            Throwable throwable = null;
            try (AutoCloseable deploymentTimer = Performance.time((String)("deployment: " + deployment.getName()));){
                ModelNode result;
                block33: {
                    String exportLocation;
                    Object depContainer;
                    if (deployment instanceof DependenciesContainer && (depContainer = (DependenciesContainer)deployment).hasMarker("org.wildfly.swarm.allDependencies") && !depContainer.hasMarker(ALL_DEPENDENCIES_ADDED_MARKER)) {
                        ApplicationEnvironment appEnv = ApplicationEnvironment.get();
                        if (ApplicationEnvironment.Mode.UBERJAR == appEnv.getMode()) {
                            ArtifactLookup artifactLookup = ArtifactLookup.get();
                            for (String gav : appEnv.getDependencies()) {
                                depContainer.addAsLibrary((Archive)artifactLookup.artifact(gav));
                            }
                        } else {
                            Set paths = appEnv.resolveDependencies(Collections.emptyList());
                            for (String path : paths) {
                                File pathFile = new File(path);
                                if (path.endsWith(".jar")) {
                                    depContainer.addAsLibrary(pathFile);
                                    continue;
                                }
                                if (!pathFile.isDirectory()) continue;
                                depContainer.merge((Archive)((ExplodedImporter)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).as(ExplodedImporter.class)).importDirectory(pathFile).as(GenericArchive.class), "/WEB-INF/classes", Filters.includeAll());
                            }
                        }
                        depContainer.addMarker(ALL_DEPENDENCIES_ADDED_MARKER);
                    }
                    this.deploymentContext.activate(deployment, asName, !this.implicitDeploymentsComplete);
                    for (Object processor : this.deploymentProcessors) {
                        processor.process();
                    }
                    this.deploymentContext.deactivate();
                    if (DeployerMessages.MESSAGES.isDebugEnabled()) {
                        DeployerMessages.MESSAGES.deploying(deployment.getName());
                        Map ctx = deployment.getContent();
                        for (Map.Entry each : ctx.entrySet()) {
                            DeployerMessages.MESSAGES.deploymentContent(((ArchivePath)each.getKey()).toString());
                        }
                    }
                    if (BootstrapProperties.flagIsSet((String)"thorntail.export.deployment") && (exportLocation = System.getProperty("thorntail.export.deployment")) != null) {
                        Path archivePath = null;
                        if (exportLocation.toLowerCase().equals("true")) {
                            archivePath = Paths.get(deployment.getName(), new String[0]);
                        } else {
                            Path exportDir = Paths.get(exportLocation, new String[0]);
                            Files.createDirectories(exportDir, new FileAttribute[0]);
                            archivePath = exportDir.resolve(deployment.getName());
                        }
                        File out = archivePath.toFile();
                        DeployerMessages.MESSAGES.exportingDeployment(out.getAbsolutePath());
                        ((ZipExporter)deployment.as(ZipExporter.class)).exportTo(out, true);
                    }
                    byte[] hash = this.contentRepository.addContent(deployment);
                    ModelNode deploymentAdd = new ModelNode();
                    deploymentAdd.get("operation").set("add");
                    deploymentAdd.get("address").set("deployment", deployment.getName());
                    deploymentAdd.get("runtime-name").set(deployment.getName());
                    deploymentAdd.get("enabled").set(true);
                    deploymentAdd.get("persistent").set(true);
                    ModelNode content = deploymentAdd.get("content").add();
                    content.get("hash").set(hash);
                    int deploymentTimeout = Integer.getInteger("thorntail.deployment.timeout", 300);
                    ModelNode opHeaders = new ModelNode();
                    opHeaders.get("blocking-timeout").set(deploymentTimeout);
                    deploymentAdd.get("operation-headers").set(opHeaders);
                    BootstrapLogger.logger((String)"org.wildfly.swarm.runtime.deployer").info((Object)("deploying " + deployment.getName()));
                    System.setProperty("thorntail.current.deployment", deployment.getName());
                    result = this.client.execute(deploymentAdd);
                    ModelNode outcome = result.get("outcome");
                    if (!outcome.asString().equals("success")) break block33;
                    return;
                    {
                        catch (IOException e2) {
                            throw SwarmMessages.MESSAGES.deploymentFailed(e2, deployment);
                        }
                    }
                }
                try {
                    ModelNode description = result.get("failure-description");
                    throw new DeploymentException(deployment, SwarmMessages.MESSAGES.deploymentFailed(description.asString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (Exception e3) {
            throw new DeploymentException(deployment, (Throwable)e3);
        }
    }

    @PreDestroy
    void stop() {
    }

    public void removeAllContent() throws IOException {
        this.contentRepository.removeAllContent();
    }
}

