/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.bootstrap.util.JarFileManager;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.container.internal.Server;
import org.wildfly.swarm.container.runtime.ArtifactDeployer;
import org.wildfly.swarm.container.runtime.ConfigurableManager;
import org.wildfly.swarm.container.runtime.ImplicitDeployment;
import org.wildfly.swarm.container.runtime.NetworkConfigurer;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.container.runtime.deployments.DefaultDeploymentCreator;
import org.wildfly.swarm.container.runtime.marshal.DMRMarshaller;
import org.wildfly.swarm.container.runtime.usage.UsageCreator;
import org.wildfly.swarm.container.runtime.wildfly.ContentRepositoryServiceActivator;
import org.wildfly.swarm.container.runtime.wildfly.SwarmContentRepository;
import org.wildfly.swarm.container.runtime.wildfly.UUIDFactory;
import org.wildfly.swarm.container.runtime.xmlconfig.BootstrapConfiguration;
import org.wildfly.swarm.container.runtime.xmlconfig.BootstrapPersister;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.internal.wildfly.SelfContainedContainer;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.UserSpaceExtensionFactory;
import org.wildfly.swarm.spi.runtime.annotations.Post;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@ApplicationScoped
public class RuntimeServer
implements Server {
    @Inject
    @Pre
    private Instance<Customizer> preCustomizers;
    @Inject
    @Post
    private Instance<Customizer> postCustomizers;
    @Inject
    @Any
    private Instance<ServiceActivator> serviceActivators;
    @Inject
    @ImplicitDeployment
    private Instance<Archive> implicitDeployments;
    @Inject
    private DMRMarshaller dmrMarshaller;
    @Inject
    private DefaultDeploymentCreator defaultDeploymentCreator;
    @Inject
    private SwarmContentRepository contentRepository;
    @Inject
    private Instance<RuntimeDeployer> deployer;
    @Inject
    @Any
    private Instance<UserSpaceExtensionFactory> userSpaceExtensionFactories;
    @Inject
    private ConfigurableManager configurableManager;
    @Inject
    private UsageCreator usageCreator;
    private SelfContainedContainer container;
    private boolean containerStarted;
    @Inject
    private ArtifactDeployer artifactDeployer;
    @Inject
    private NetworkConfigurer networkConfigurer;
    private ModelControllerClient client;

    public RuntimeServer() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.containerStarted) {
                try {
                    SwarmMessages.MESSAGES.shutdownRequested();
                    this.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    @Produces
    @ApplicationScoped
    ModelControllerClient client() {
        return this.client;
    }

    public Deployer start(boolean eagerOpen) throws Exception {
        File configurationFile;
        UUID uuid = UUIDFactory.getUUID();
        System.setProperty("jboss.server.management.uuid", uuid.toString());
        try {
            configurationFile = TempFileManager.INSTANCE.newTempFile("thorntail-config-", ".xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.networkConfigurer.configure();
        ArrayList<ModelNode> bootstrapOperations = new ArrayList<ModelNode>();
        final BootstrapConfiguration bootstrapConfiguration = () -> bootstrapOperations;
        this.container = new SelfContainedContainer(new Bootstrap.ConfigurationPersisterFactory(){

            public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                return new BootstrapPersister(bootstrapConfiguration, configurationFile);
            }
        });
        try (AutoCloseable handle = Performance.time((String)"pre-customizers");){
            for (Customizer each : this.preCustomizers) {
                SwarmMessages.MESSAGES.callingPreCustomizer(each);
                each.customize();
            }
        }
        handle = Performance.time((String)"post-customizers");
        var7_8 = null;
        try {
            for (Customizer each : this.postCustomizers) {
                SwarmMessages.MESSAGES.callingPostCustomizer(each);
                each.customize();
            }
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var7_8 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
        this.networkConfigurer.configure();
        handle = Performance.time((String)"configurable-manager rescan");
        var7_8 = null;
        try {
            this.configurableManager.rescan();
            this.configurableManager.log();
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var7_8 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
        handle = Performance.time((String)"marshall DMR");
        var7_8 = null;
        try {
            this.dmrMarshaller.marshal(bootstrapOperations);
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var7_8 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var7_8.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
        SwarmMessages.MESSAGES.wildflyBootstrap(((Object)bootstrapOperations).toString());
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        ArrayList<ServiceActivator> activators = new ArrayList<ServiceActivator>();
        StreamSupport.stream(this.serviceActivators.spliterator(), false).filter(Objects::nonNull).forEach(activators::add);
        activators.add(new ContentRepositoryServiceActivator(this.contentRepository));
        AutoCloseable wildflyStart = Performance.time((String)"WildFly start");
        Object object = null;
        try {
            ServiceContainer serviceContainer = null;
            AutoCloseable startWildflyItself = Performance.time((String)"Starting WildFly itself");
            Object object2 = null;
            try {
                serviceContainer = this.container.start(bootstrapOperations, activators);
                this.containerStarted = true;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (startWildflyItself != null) {
                    if (object2 != null) {
                        try {
                            startWildflyItself.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        startWildflyItself.close();
                    }
                }
            }
            AutoCloseable checkFailedServices = Performance.time((String)"Checking for failed services");
            object2 = null;
            try {
                for (ServiceName serviceName : serviceContainer.getServiceNames()) {
                    ServiceController serviceController = serviceContainer.getService(serviceName);
                    StartException exception = serviceController.getStartException();
                    if (exception == null) continue;
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (checkFailedServices != null) {
                    if (object2 != null) {
                        try {
                            checkFailedServices.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        checkFailedServices.close();
                    }
                }
            }
            AutoCloseable creatingControllerClient = Performance.time((String)"Creating controller client");
            object2 = null;
            try {
                ExecutorService executor = Executors.newSingleThreadExecutor();
                ModelControllerClientFactory clientFactory = (ModelControllerClientFactory)serviceContainer.getService(ServerService.JBOSS_SERVER_CLIENT_FACTORY).getValue();
                this.client = clientFactory.createSuperUserClient((Executor)executor);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (creatingControllerClient != null) {
                    if (object2 != null) {
                        try {
                            creatingControllerClient.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        creatingControllerClient.close();
                    }
                }
            }
            RuntimeDeployer deployer = (RuntimeDeployer)this.deployer.get();
            AutoCloseable installDeployer = Performance.time((String)"Installing deployer");
            Object object3 = null;
            try {
                serviceContainer.addService(ServiceName.of((String[])new String[]{"thorntail", "deployer"}), (Service)new ValueService((Value)new ImmediateValue((Object)deployer))).install();
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (installDeployer != null) {
                    if (object3 != null) {
                        try {
                            installDeployer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        installDeployer.close();
                    }
                }
            }
            AutoCloseable configUserSpaceExt = Performance.time((String)"Configure user-space extensions");
            object3 = null;
            try {
                this.configureUserSpaceExtensions();
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (configUserSpaceExt != null) {
                    if (object3 != null) {
                        try {
                            configUserSpaceExt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        configUserSpaceExt.close();
                    }
                }
            }
            AutoCloseable deployments = Performance.time((String)"Implicit Deployments");
            object3 = null;
            try {
                for (Archive each : this.implicitDeployments) {
                    if (each == null) continue;
                    deployer.deploy(each);
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (deployments != null) {
                    if (object3 != null) {
                        try {
                            deployments.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        deployments.close();
                    }
                }
            }
            this.artifactDeployer.deploy();
            deployer.implicitDeploymentsComplete();
            object2 = deployer;
            return object2;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (wildflyStart != null) {
                if (object != null) {
                    try {
                        wildflyStart.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    wildflyStart.close();
                }
            }
        }
    }

    private void configureUserSpaceExtensions() {
        this.userSpaceExtensionFactories.forEach(factory -> {
            try {
                factory.configure();
            }
            catch (Exception e) {
                SwarmMessages.MESSAGES.errorInstallingUserSpaceExtension(factory.getClass().getName());
            }
        });
    }

    @Override
    public void stop() throws Exception {
        Class<?>[] declaredClasses;
        this.container.stop();
        this.awaitContainerTermination();
        this.containerStarted = false;
        Field field = this.container.getClass().getDeclaredField("serviceContainer");
        field.setAccessible(true);
        ServiceContainer serviceContainer = (ServiceContainer)field.get(this.container);
        Class<?> shutdownHookHolder = null;
        for (Class<?> clazz : declaredClasses = serviceContainer.getClass().getDeclaredClasses()) {
            if (!clazz.getName().contains("ShutdownHookHolder")) continue;
            shutdownHookHolder = clazz;
        }
        if (shutdownHookHolder != null) {
            Field containersSetField = shutdownHookHolder.getDeclaredField("containers");
            containersSetField.setAccessible(true);
            Set set = (Set)containersSetField.get(null);
            set.clear();
        }
        this.container = null;
        this.client = null;
        ((RuntimeDeployer)this.deployer.get()).removeAllContent();
        this.deployer = null;
        this.cleanup();
    }

    private void cleanup() throws IOException {
        JarFileManager.INSTANCE.close();
        TempFileManager.INSTANCE.close();
        MavenResolvers.close();
    }

    private void awaitContainerTermination() {
        try {
            Field field = this.container.getClass().getDeclaredField("executor");
            field.setAccessible(true);
            ExecutorService executor = (ExecutorService)field.get(this.container);
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (IllegalAccessException | InterruptedException | NoSuchFieldException e) {
            SwarmMessages.MESSAGES.errorWaitingForContainerShutdown(e);
        }
    }

    @Override
    public Deployer deployer() {
        return (Deployer)this.deployer.get();
    }

    @Override
    public void displayUsage() throws Exception {
        String message = this.usageCreator.getUsageMessage();
        if (message != null) {
            SwarmMessages.MESSAGES.usage(message);
        }
        this.configurableManager.close();
    }
}

