/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi.configurable;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Singleton;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.container.runtime.ConfigurableManager;
import org.wildfly.swarm.container.runtime.cdi.configurable.ConfigurableInjectionTarget;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.cdi.CommonBean;
import org.wildfly.swarm.spi.api.cdi.CommonBeanBuilder;

public class ConfigurableExtension
implements Extension {
    private final ConfigurableManager configurableManager;
    private static final Set<Class<?>> APPLICABLE_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(Customizer.class);
            this.add(DeploymentProcessor.class);
        }
    };

    public ConfigurableExtension(ConfigurableManager configurableManager) {
        this.configurableManager = configurableManager;
    }

    <T> void processInjectionTarget(@Observes ProcessInjectionTarget<T> pit, BeanManager beanManager) throws Exception {
        try (AutoCloseable handle = Performance.accumulate((String)"ConfigurationExtension.processInjectionTarget");){
            if (ConfigurableExtension.isApplicable(pit.getAnnotatedType())) {
                pit.setInjectionTarget(new ConfigurableInjectionTarget(pit.getInjectionTarget(), this.configurableManager));
            }
        }
    }

    private static <T> boolean isApplicable(AnnotatedType<T> at) {
        if (ConfigurableExtension.isApplicable(at.getJavaClass())) {
            return true;
        }
        Set fields = at.getFields();
        for (AnnotatedField field : fields) {
            if (!field.isAnnotationPresent(Configurable.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isApplicable(Class<?> cls) {
        for (Class<?> each : APPLICABLE_CLASSES) {
            if (!each.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd) throws Exception {
        try (AutoCloseable handle = Performance.time((String)"ConfigurationExtension.afterBeanDiscovery");){
            CommonBean configurableManagerBean = CommonBeanBuilder.newBuilder(ConfigurableManager.class).beanClass(ConfigurableManager.class).scope(Singleton.class).addQualifier((Annotation)Default.Literal.INSTANCE).createSupplier(() -> this.configurableManager).addType(ConfigurableManager.class).addType(Object.class).build();
            abd.addBean((Bean)configurableManagerBean);
        }
    }
}

