/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.usage;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.swarm.container.runtime.usage.UsageProvider;

@ApplicationScoped
public class ModuleUsageProvider
implements UsageProvider {
    String USAGE_TXT = "usage.txt";
    String META_INF_USAGE_TXT = "META-INF/" + this.USAGE_TXT;
    String WEB_INF_USAGE_TXT = "WEB-INF/" + this.USAGE_TXT;

    @Override
    public String getRawUsageText() throws Exception {
        Module module = Module.getBootModuleLoader().loadModule("thorntail.application");
        ModuleClassLoader cl = module.getClassLoader();
        InputStream in = cl.getResourceAsStream(this.META_INF_USAGE_TXT);
        if (in == null) {
            in = cl.getResourceAsStream(this.WEB_INF_USAGE_TXT);
        }
        if (in == null) {
            in = cl.getResourceAsStream(this.USAGE_TXT);
        }
        if (in != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String string = reader.lines().collect(Collectors.joining("\n"));
                return string;
            }
        }
        return null;
    }
}

