/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.usage;

import java.util.Iterator;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.runtime.usage.UsageVariableSupplier;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;

public class NetworkVariableSupplier
implements UsageVariableSupplier {
    private final UsageVariableSupplier delegate;
    private final Iterable<SocketBindingGroup> socketBindings;
    private final Iterable<Interface> interfaces;

    public NetworkVariableSupplier(Iterable<Interface> interfaces, Iterable<SocketBindingGroup> socketBindings, UsageVariableSupplier delegate) {
        this.interfaces = interfaces;
        this.socketBindings = socketBindings;
        this.delegate = delegate;
    }

    @Override
    public Object valueOf(String name) throws Exception {
        if (name.equals("thorntail.public.url.base")) {
            return "http://" + this.valueOf("thorntail.public.host") + ":" + this.valueOf("thorntail.http.port") + "/";
        }
        String[] parts = name.split("\\.");
        if (parts.length > 0 && parts[0].equals("swarm")) {
            SocketBindingGroup each;
            if (parts.length == 3) {
                for (Interface each2 : this.interfaces) {
                    if (!parts[1].equals(each2.getName()) || !parts[2].equals("host")) continue;
                    return each2.getExpression();
                }
            }
            Object value = null;
            Iterator<SocketBindingGroup> iterator = this.socketBindings.iterator();
            while (iterator.hasNext() && (value = this.valueOf(each = iterator.next(), name)) == null) {
            }
            if (value != null) {
                return value;
            }
        }
        return this.delegate.valueOf(name);
    }

    protected Object valueOf(SocketBindingGroup group, String name) throws Exception {
        String[] parts = name.split("\\.");
        String bindingName = null;
        String which = "port";
        if (parts.length == 3) {
            bindingName = parts[1];
        } else if (parts.length == 4) {
            bindingName = parts[1];
            which = parts[2];
        }
        int offset = Integer.parseInt(group.portOffsetExpression());
        for (SocketBinding socketBinding : group.socketBindings()) {
            if (!socketBinding.name().equals(bindingName)) continue;
            if (which.equals("port")) {
                int port = Integer.parseInt(socketBinding.portExpression());
                return "" + (port + offset);
            }
            if (which.equals("multicast-port")) {
                int port = Integer.parseInt(socketBinding.multicastPortExpression());
                return "" + (port + offset);
            }
            if (which.equals("multicast-address")) {
                String addr = socketBinding.multicastAddress();
                return addr;
            }
            if (!which.equals("host")) continue;
            return this.valueOf("thorntail." + socketBinding.iface() + ".host");
        }
        return null;
    }
}

