/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wildfly.swarm.internal.FileSystemLayout;

public class GradleFileSystemLayout
extends FileSystemLayout {
    public static final String SYSTEM_PROPERTY_BUILD_DIR = "build.dir";
    public static final String SYSTEM_PROPERTY_SRC_DIR = "src.dir";
    public static final String SRC_DIR_NAME = "src";
    public static final String BUILD_DIR_NAME = "build";
    private final Path sourceRoot;
    private final Path buildRoot;
    private final Path classesDir;
    protected static final String CLASSES = "classes";
    protected static final String SOURCE_SET_MAIN = "main";
    protected static final String RESOURCES = "resources";
    protected static final String WEBAPP = "webapp";
    private static final String JAVA = "java";

    GradleFileSystemLayout(String root) {
        super(root);
        String value = System.getProperty(SYSTEM_PROPERTY_SRC_DIR, SRC_DIR_NAME);
        this.sourceRoot = this.rootPath.resolve(Paths.get(value, new String[0]));
        value = System.getProperty(SYSTEM_PROPERTY_BUILD_DIR, BUILD_DIR_NAME);
        this.buildRoot = this.rootPath.resolve(Paths.get(value, new String[0]));
        Path path = this.buildRoot.resolve(CLASSES).resolve(JAVA).resolve(SOURCE_SET_MAIN);
        this.classesDir = Files.exists(path, new LinkOption[0]) ? path : this.buildRoot.resolve(CLASSES).resolve(SOURCE_SET_MAIN);
    }

    @Override
    public String determinePackagingType() {
        if (this.resolveSrcWebAppDir().toFile().exists()) {
            return "war";
        }
        return "jar";
    }

    @Override
    public Path resolveBuildClassesDir() {
        return this.classesDir;
    }

    @Override
    public Path resolveBuildResourcesDir() {
        return this.buildRoot.resolve(RESOURCES).resolve(SOURCE_SET_MAIN);
    }

    @Override
    public Path resolveSrcWebAppDir() {
        return this.sourceRoot.resolve(SOURCE_SET_MAIN).resolve(WEBAPP);
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }

    protected Path getBuildRoot() {
        return this.buildRoot;
    }
}

