/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import org.wildfly.swarm.internal.FileSystemLayout;

public class MavenFileSystemLayout
extends FileSystemLayout {
    private static final String TARGET = "target";
    private static final String CLASSES = "classes";
    private static final String SRC = "src";
    private static final String MAIN = "main";
    private static final String WEBAPP = "webapp";
    private static final String POM_XML = "pom.xml";
    private static final String PACKAGING_JAR = "<packaging>jar</packaging>";
    private static final String PACKAGING_WAR = "<packaging>war</packaging>";

    MavenFileSystemLayout(String root) {
        super(root);
    }

    @Override
    public Path resolveBuildClassesDir() {
        return this.rootPath.resolve(TARGET).resolve(CLASSES);
    }

    @Override
    public Path resolveBuildResourcesDir() {
        return this.resolveBuildClassesDir();
    }

    @Override
    public Path resolveSrcWebAppDir() {
        return this.rootPath.resolve(SRC).resolve(MAIN).resolve(WEBAPP);
    }

    @Override
    public String determinePackagingType() {
        String type = null;
        try (BufferedReader in = new BufferedReader(new FileReader(this.rootPath.resolve(POM_XML).toFile()));){
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals(PACKAGING_JAR)) {
                    type = "jar";
                    continue;
                }
                if (!line.equals(PACKAGING_WAR)) continue;
                type = "war";
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (null == type) {
            type = this.resolveSrcWebAppDir().toFile().exists() ? "war" : "jar";
        }
        return type;
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }
}

