/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.container.DeploymentException;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;

public class SwarmMessages_$logger
extends DelegatingBasicLogger
implements SwarmMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SwarmMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public SwarmMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String containerNotStarted$str() {
        return "THORN0001: Cannot invoke %s on a container that has not been started.";
    }

    @Override
    public final IllegalStateException containerNotStarted(String method) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.containerNotStarted$str(), method));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String argumentRequired$str() {
        return "THORN0002: %s requires an argument.";
    }

    @Override
    public final RuntimeException argumentRequired(String arg) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.argumentRequired$str(), arg));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failToMountDeployment$str() {
        return "THORN0003: Failed to mount deployment.";
    }

    @Override
    public final DeploymentException failToMountDeployment(Throwable cause, Archive<?> archive) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.failToMountDeployment$str(), new Object[0]), cause, archive);
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentFailed1$str() {
        return "THORN0004: Deployment failed: %s";
    }

    @Override
    public final String deploymentFailed(String failureMessage) {
        return String.format(this.getLoggingLocale(), this.deploymentFailed1$str(), failureMessage);
    }

    protected String deploymentFailed0$str() {
        return "THORN0005: Failure during deployment";
    }

    @Override
    public final DeploymentException deploymentFailed(Throwable cause, Archive<?> archive) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.deploymentFailed0$str(), new Object[0]), cause, archive);
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String librariesNotSupported$str() {
        return "THORN0006: JavaArchive spec does not support Libraries";
    }

    @Override
    public final UnsupportedOperationException librariesNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.librariesNotSupported$str(), new Object[0]));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fractionHasMultipleExtensions$str() {
        return "THORN0007: Fraction \"%s\" was configured using @WildFlyExtension with a module='', but has multiple extension classes.  Please use classname='' to specify exactly one, or noClass=true to ignore all. %s";
    }

    @Override
    public final RuntimeException fractionHasMultipleExtensions(String className, Collection<String> extensions) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.fractionHasMultipleExtensions$str(), className, extensions));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String artifactNotFound$str() {
        return "THORN0008: Artifact '%s' not found.";
    }

    @Override
    public final RuntimeException artifactNotFound(String gav) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.artifactNotFound$str(), gav));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDetermineVersion$str() {
        return "THORN0009: Unable to determine version number from GAV: %s";
    }

    @Override
    public final RuntimeException unableToDetermineVersion(String gav) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToDetermineVersion$str(), gav));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String gavMinimumSegments$str() {
        return "THORN0010: GAV must includes at least 2 segments";
    }

    @Override
    public final RuntimeException gavMinimumSegments() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.gavMinimumSegments$str(), new Object[0]));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String systemPropertyNotFound$str() {
        return "THORN0011: System property '%s' not provided.";
    }

    @Override
    public final IllegalStateException systemPropertyNotFound(String key) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.systemPropertyNotFound$str(), key));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotIdentifyFileSystemLayout$str() {
        return "THORN0012: Cannot identify FileSystemLayout for given path: %s";
    }

    @Override
    public final IllegalArgumentException cannotIdentifyFileSystemLayout(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotIdentifyFileSystemLayout$str(), path));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String availableFraction$str() {
        return "THORN0013: Installed fraction: %24s - %-15s %s:%s:%s";
    }

    @Override
    public final String availableFraction(String name, String stabilityLevel, String groupId, String artifactId, String version) {
        return String.format(this.getLoggingLocale(), this.availableFraction$str(), name, stabilityLevel, groupId, artifactId, version);
    }

    @Override
    public final void shrinkwrapDomainSetupFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.shrinkwrapDomainSetupFailed$str(), new Object[0]);
    }

    protected String shrinkwrapDomainSetupFailed$str() {
        return "THORN0014: Unable to setup Shrinkwrap Domain";
    }

    @Override
    public final void deploymentModuleAdded(DeploymentModule module) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.deploymentModuleAdded$str(), (Object)module);
    }

    protected String deploymentModuleAdded$str() {
        return "THORN0015: Add deployment module: %s";
    }

    @Override
    public final void callingPreCustomizer(Customizer customizer) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.callingPreCustomizer$str(), (Object)customizer);
    }

    protected String callingPreCustomizer$str() {
        return "THORN0016: Calling Pre Customizer: %s";
    }

    @Override
    public final void callingPostCustomizer(Customizer customizer) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.callingPostCustomizer$str(), (Object)customizer);
    }

    protected String callingPostCustomizer$str() {
        return "THORN0017: Calling Post Customizer: %s";
    }

    @Override
    public final void wildflyBootstrap(String operations) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.wildflyBootstrap$str(), (Object)operations);
    }

    protected String wildflyBootstrap$str() {
        return "THORN0018: WildFly Bootstrap operations: \n %s";
    }

    @Override
    public final void argsInstalled(List<String> args) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.argsInstalled$str(), args);
    }

    protected String argsInstalled$str() {
        return "THORN0019: Install MSC service for command line args: %s";
    }

    protected String httpsRequiresManagementFraction$str() {
        return "THORN0020: HTTP/S is configured correctly, but io.thorntail:management is not available";
    }

    @Override
    public final RuntimeException httpsRequiresManagementFraction() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.httpsRequiresManagementFraction$str(), new Object[0]));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoringSubsystem(String nsURI, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringSubsystem$str(), (Object)nsURI, (Object)name);
    }

    protected String ignoringSubsystem$str() {
        return "THORN0021: Ignoring subsystem %s:%s";
    }

    @Override
    public final void moduleMBeanServerNotInstalled(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.moduleMBeanServerNotInstalled$str(), new Object[0]);
    }

    protected String moduleMBeanServerNotInstalled$str() {
        return "THORN0022: Failed to register modules mbeans";
    }

    @Override
    public final void errorInstallingUserSpaceExtension(String factoryClassName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.errorInstallingUserSpaceExtension$str(), (Object)factoryClassName);
    }

    protected String errorInstallingUserSpaceExtension$str() {
        return "THORN0023: Error installing user-space CDI extension: %s";
    }

    @Override
    public final void http2NotSupported() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.http2NotSupported$str(), new Object[0]);
    }

    protected String http2NotSupported$str() {
        return "THORN0024: In order to use HTTP/2 in Thorntail, you must have the OpenSSL provider with ALPN capability from JBoss Core Services installed and configured. This is due to the fact that HTTP/2 requires a TLS stack that supports ALPN, which is not provided by the default installation of Java 8. HTTP/2 will only work with browsers that also support the HTTP/2 standard. OpenSSL usage with Thorntail on HP-UX is NOT supported.";
    }

    protected String generateSelfSignedCertificateNotSupported$str() {
        return "THORN0025: This version of Thorntail does not support generating self signed certificates.";
    }

    @Override
    public final RuntimeException generateSelfSignedCertificateNotSupported() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.generateSelfSignedCertificateNotSupported$str(), new Object[0]));
        SwarmMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failToInvokeGenerateSelfSignedCertificateHost(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failToInvokeGenerateSelfSignedCertificateHost$str(), new Object[0]);
    }

    protected String failToInvokeGenerateSelfSignedCertificateHost$str() {
        return "THORN0026: Error invoking SslServerIdentity.generateSelfSignedCertificateHost(String) in HTTPSCustomizer.";
    }

    @Override
    public final void shutdownRequested() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shutdownRequested$str(), new Object[0]);
    }

    protected String shutdownRequested$str() {
        return "THORN0027: Shutdown requested";
    }

    @Override
    public final void errorWaitingForContainerShutdown(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorWaitingForContainerShutdown$str(), new Object[0]);
    }

    protected String errorWaitingForContainerShutdown$str() {
        return "THORN0028: Error invoking SslServerIdentity.generateSelfSignedCertificateHost(String) in HTTPSCustomizer.";
    }

    @Override
    public final void errorSettingUpTempFileProvider(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorSettingUpTempFileProvider$str(), new Object[0]);
    }

    protected String errorSettingUpTempFileProvider$str() {
        return "THORN0029: Error setting up temporary file provider.";
    }

    @Override
    public final void errorCleaningUpTempFileProvider(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorCleaningUpTempFileProvider$str(), new Object[0]);
    }

    protected String errorCleaningUpTempFileProvider$str() {
        return "THORN0030: Error cleaning up temporary file provider.";
    }

    @Override
    public final void registeredArchivePreparer(String preparer) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.registeredArchivePreparer$str(), (Object)preparer);
    }

    protected String registeredArchivePreparer$str() {
        return "THORN0031: Registered archive-preparer: %s";
    }

    protected String invalidFileSystemLayoutProvided$str() {
        return "THORN0032: Invalid file system layout: %s";
    }

    @Override
    public final String invalidFileSystemLayoutProvided(String message) {
        return String.format(this.getLoggingLocale(), this.invalidFileSystemLayoutProvided$str(), message);
    }

    @Override
    public final void usage(String message) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.usage$str(), (Object)message);
    }

    protected String usage$str() {
        return "THORN88888: %n%n========================================================================%n%n%s%n%n========================================================================%n";
    }

    @Override
    public final void wildflySwarmIsReady() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.wildflySwarmIsReady$str(), new Object[0]);
    }

    protected String wildflySwarmIsReady$str() {
        return "THORN99999: Thorntail is Ready";
    }
}

