/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.datasources.internal;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.wildfly.swarm.config.datasources.DataSource;
import org.wildfly.swarm.config.datasources.DataSourceConsumer;
import org.wildfly.swarm.datasources.DSXmlAsset;
import org.wildfly.swarm.datasources.DatasourceArchive;

public class DatasourceArchiveImpl
extends ContainerBase<DatasourceArchive>
implements DatasourceArchive {
    public DatasourceArchiveImpl(Archive<?> archive) {
        super(DatasourceArchive.class, archive);
    }

    @Override
    public DatasourceArchive dataSource(String key, DataSourceConsumer consumer) {
        DataSource ds = new DataSource(key);
        consumer.accept(ds);
        this.dataSource(ds);
        return this;
    }

    @Override
    public DatasourceArchive dataSource(DataSource ds) {
        if (ds.jndiName() == null) {
            ds.jndiName("java:jboss/datasources/" + ds.getKey());
        }
        String name = ds.getKey() + "-ds.xml";
        this.getArchive().add((Asset)new DSXmlAsset(ds), "META-INF/" + name);
        return this;
    }

    protected ArchivePath getManifestPath() {
        return null;
    }

    protected ArchivePath getResourcePath() {
        return null;
    }

    protected ArchivePath getClassesPath() {
        return null;
    }

    protected ArchivePath getLibraryPath() {
        return null;
    }
}

