/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.datasources.runtime;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.wildfly.swarm.config.datasources.DataSource;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.datasources.runtime.DatasourcesMessages;
import org.wildfly.swarm.datasources.runtime.DefaultDatasource;
import org.wildfly.swarm.datasources.runtime.DriverInfo;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@ApplicationScoped
public class DatasourceAndDriverCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<DriverInfo> allDrivers;
    @Inject
    DatasourcesFraction fraction;
    private String defaultDatasourceName;
    private String defaultDatasourceJndiName;
    @AttributeDocumentation(value="Name of the default datasource")
    @Configurable(value="thorntail.ds.name")
    private String datasourceName = "ExampleDS";
    @AttributeDocumentation(value="Default datasource connection URL")
    @Configurable(value="thorntail.ds.connection.url")
    private String datasourceConnectionUrl;
    @AttributeDocumentation(value="Default datasource connection user name")
    @Configurable(value="thorntail.ds.username")
    private String datasourceUserName;
    @AttributeDocumentation(value="Defatul datasource connection password")
    @Configurable(value="thorntail.ds.password")
    private String datasourcePassword;
    @AttributeDocumentation(value="Defatul datasource JDBC driver name")
    @Configurable(value="thorntail.jdbc.driver")
    private String driverName;

    public void customize() {
        this.customizeJDBCDrivers();
        this.customizeDefaultDatasource();
    }

    protected void customizeJDBCDrivers() {
        this.allDrivers.forEach(this::attemptInstallation);
    }

    protected void customizeDefaultDatasource() {
        List datasources = this.fraction.subresources().dataSources();
        if (datasources.isEmpty()) {
            this.defaultDatasourceName = this.createDefaultDatasource();
        } else {
            this.defaultDatasourceName = ((DataSource)datasources.get(0)).getKey();
            this.defaultDatasourceJndiName = ((DataSource)datasources.get(0)).jndiName();
        }
    }

    private String createDefaultDatasource() {
        if (this.fraction.subresources().dataSource(this.datasourceName) != null) {
            DatasourcesMessages.MESSAGES.notCreatingDatasourceAlreadyExists(this.datasourceName);
            return this.datasourceName;
        }
        Optional<Object> driverForDefaultDS = Optional.empty();
        if (this.driverName != null) {
            driverForDefaultDS = StreamSupport.stream(this.allDrivers.spliterator(), false).filter(e -> e.name().equals(this.driverName)).findFirst();
        } else {
            List installedDrivers = StreamSupport.stream(this.allDrivers.spliterator(), false).filter(DriverInfo::isInstalled).collect(Collectors.toList());
            if (installedDrivers.size() == 1) {
                driverForDefaultDS = Optional.of(installedDrivers.get(0));
            } else if (installedDrivers.size() > 1) {
                List driverNames = installedDrivers.stream().map(e -> e.name()).collect(Collectors.toList());
                DatasourcesMessages.MESSAGES.notCreatingDatasourceAmbiguousDrivers(String.join((CharSequence)",", driverNames));
                return null;
            }
        }
        if (!driverForDefaultDS.isPresent()) {
            DatasourcesMessages.MESSAGES.notCreatingDatasourceMissingDriver();
            return null;
        }
        ((DriverInfo)driverForDefaultDS.get()).installDatasource(this.fraction, this.datasourceName, ds -> {
            if (this.datasourceConnectionUrl != null) {
                ds.connectionUrl(this.datasourceConnectionUrl);
            }
            if (this.datasourceUserName != null) {
                ds.userName(this.datasourceUserName);
            }
            if (this.datasourcePassword != null) {
                ds.password(this.datasourcePassword);
            }
        });
        return this.datasourceName;
    }

    protected void attemptInstallation(DriverInfo info) {
        if (info.detect(this.fraction)) {
            DatasourcesMessages.MESSAGES.autodetectedJdbcDriver(info.name());
        }
    }

    public String getDatasourceName() {
        return this.defaultDatasourceName;
    }

    @Produces
    @Dependent
    @DefaultDatasource
    public String getDatasourceJndiName() {
        if (this.defaultDatasourceJndiName == null && this.defaultDatasourceName != null) {
            for (DataSource ds : this.fraction.subresources().dataSources()) {
                if (!this.defaultDatasourceName.equals(ds.getKey())) continue;
                if (ds.jndiName() != null) {
                    return ds.jndiName();
                }
                return "java:jboss/datasources/" + this.defaultDatasourceName;
            }
        }
        return this.defaultDatasourceJndiName;
    }
}

