/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Properties loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        return props;
    }

    public static Properties loadProperties(String fileString) throws IOException {
        File file = new File(fileString);
        if (file.exists()) {
            return PropertiesUtil.loadProperties(file);
        }
        InputStream resourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileString);
        if (resourceStream != null) {
            return PropertiesUtil.loadProperties(resourceStream);
        }
        try {
            URL url = new URL(fileString);
            return PropertiesUtil.loadProperties(url.openStream());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Unable to find " + fileString);
        }
    }

    public static Properties loadProperties(File file) throws IOException {
        return PropertiesUtil.loadProperties(new FileInputStream(file));
    }

    public static String versionFromPomProperties() {
        try {
            return PropertiesUtil.loadProperties(PropertiesUtil.class.getClassLoader().getResourceAsStream("META-INF/maven/org.wildfly.swarm/tools/pom.properties")).getProperty("version");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load version from pom.properties", e);
        }
    }

    public static Properties filteredSystemProperties(Properties existing, boolean withMaven) {
        Properties properties = new Properties();
        System.getProperties().stringPropertyNames().forEach(key -> {
            if (key.startsWith("jboss.") || key.startsWith("swarm.") || key.startsWith("thorntail.") || key.startsWith("wildfly.") || withMaven && key.startsWith("maven.") || existing.containsKey(key)) {
                properties.put(key, System.getProperty(key));
            }
        });
        return properties;
    }
}

