/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.ExternalDependency;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.wildfly.swarm.plugin.gradle.DependencyDescriptor;
import org.wildfly.swarm.plugin.gradle.GradleToolingHelper;
import org.wildfly.swarm.plugin.gradle.ThorntailConfiguration;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;

public class GradleDependencyAdapter {
    private Path rootPath;
    private static final Map<Path, DeclaredDependencies> PREVIOUSLY_COMPUTED_VALUES = new HashMap<Path, DeclaredDependencies>();
    private static final Map<String, Map<String, Set<ArtifactSpec>>> ARTIFACT_DEPS_OF_PRJ = new HashMap<String, Map<String, Set<ArtifactSpec>>>();
    private static final Map<String, Set<String>> PRJ_DEPS_OF_PRJ = new HashMap<String, Set<String>>();
    private static final String DEP_SCOPE_COMPILE = "COMPILE";
    private static final String DEP_SCOPE_TEST = "TEST";
    private static final String DEP_SCOPE_PROVIDED = "PROVIDED";

    public GradleDependencyAdapter(Path projectDir) {
        this.rootPath = projectDir;
    }

    public DeclaredDependencies getProjectDependencies() {
        return PREVIOUSLY_COMPUTED_VALUES.computeIfAbsent(this.rootPath, __ -> {
            DeclaredDependencies declaredDependencies;
            File projectDir = this.rootPath.toFile();
            GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(projectDir);
            String gradleVersion = System.getenv("THORNTAIL_ARQUILLIAN_GRADLE_VERSION");
            if (gradleVersion != null) {
                connector.useGradleVersion(gradleVersion);
            }
            try (ProjectConnection connection = connector.connect();){
                declaredDependencies = this.getDependenciesViaThorntailModel(connection);
                if (declaredDependencies == null) {
                    System.err.println("The 'thorntail-arquillian' plugin is missing on your project. Falling back to IdeaProject model which may not give accurate results.");
                    declaredDependencies = this.getDependenciesViaIdeaModel(connection);
                }
            }
            return declaredDependencies;
        });
    }

    private DeclaredDependencies getDependenciesViaIdeaModel(ProjectConnection connection) {
        DeclaredDependencies declaredDependencies = new DeclaredDependencies();
        IdeaProject prj = (IdeaProject)connection.getModel(IdeaProject.class);
        prj.getModules().forEach(this::computeProjectDependencies);
        Optional<IdeaModule> prjModule = prj.getModules().stream().filter(m -> m.getGradleProject().getProjectDirectory().toPath().equals(this.rootPath)).findFirst();
        HashSet collectedDependencies = new HashSet();
        prjModule.ifPresent(m -> {
            Map<String, Set<ArtifactSpec>> currentPrjDeps = ARTIFACT_DEPS_OF_PRJ.get(m.getName());
            Set<String> upstreamProjects = PRJ_DEPS_OF_PRJ.getOrDefault(m.getName(), Collections.emptySet());
            collectedDependencies.addAll(currentPrjDeps.getOrDefault(DEP_SCOPE_COMPILE, Collections.emptySet()));
            collectedDependencies.addAll(currentPrjDeps.getOrDefault(DEP_SCOPE_TEST, Collections.emptySet()));
            upstreamProjects.forEach(moduleName -> {
                Map moduleDeps = ARTIFACT_DEPS_OF_PRJ.getOrDefault(moduleName, Collections.emptyMap());
                collectedDependencies.addAll(moduleDeps.getOrDefault(DEP_SCOPE_COMPILE, Collections.emptySet()));
            });
            Set providedScopeDeps = currentPrjDeps.getOrDefault(DEP_SCOPE_PROVIDED, Collections.emptySet());
            providedScopeDeps.removeAll(collectedDependencies);
            if (!providedScopeDeps.isEmpty()) {
                ArrayList testScopedLibs = new ArrayList();
                upstreamProjects.forEach(moduleName -> testScopedLibs.addAll(ARTIFACT_DEPS_OF_PRJ.getOrDefault(moduleName, Collections.emptyMap()).getOrDefault(DEP_SCOPE_TEST, Collections.emptySet())));
                providedScopeDeps.stream().filter(testScopedLibs::contains).forEach(collectedDependencies::add);
            }
        });
        collectedDependencies.forEach(arg_0 -> ((DeclaredDependencies)declaredDependencies).add(arg_0));
        return declaredDependencies;
    }

    private void computeProjectDependencies(IdeaModule module) {
        ARTIFACT_DEPS_OF_PRJ.computeIfAbsent(module.getName(), moduleName -> {
            HashMap dependencies = new HashMap();
            module.getDependencies().forEach(dep -> {
                if (dep instanceof IdeaModuleDependency) {
                    String name = ((IdeaModuleDependency)dep).getTargetModuleName();
                    PRJ_DEPS_OF_PRJ.computeIfAbsent((String)moduleName, key -> new HashSet()).add(name);
                } else if (dep instanceof ExternalDependency) {
                    ExternalDependency extDep = (ExternalDependency)dep;
                    GradleModuleVersion gav = extDep.getGradleModuleVersion();
                    ArtifactSpec spec = new ArtifactSpec("compile", gav.getGroup(), gav.getName(), gav.getVersion(), "jar", null, extDep.getFile());
                    String depScope = dep.getScope().getScope();
                    dependencies.computeIfAbsent(depScope, s -> new HashSet()).add(spec);
                }
            });
            return dependencies;
        });
    }

    private DeclaredDependencies getDependenciesViaThorntailModel(ProjectConnection connection) {
        DeclaredDependencies declaredDependencies = null;
        try {
            ThorntailConfiguration config = (ThorntailConfiguration)connection.getModel(ThorntailConfiguration.class);
            if (config != null) {
                declaredDependencies = GradleToolingHelper.toDeclaredDependencies((Map)config.getTestDependencies());
            }
        }
        catch (IllegalStateException | GradleConnectionException e) {
            e.printStackTrace();
        }
        return declaredDependencies;
    }

    private static ArtifactSpec toArtifactSpec(DependencyDescriptor desc, String scope) {
        return new ArtifactSpec(scope, desc.getGroup(), desc.getName(), desc.getVersion(), desc.getType(), desc.getClassifier(), desc.getFile());
    }
}

