/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter.gradle;

import java.util.Collection;
import org.wildfly.swarm.arquillian.adapter.DependencyDeclarationFactory;
import org.wildfly.swarm.arquillian.adapter.gradle.GradleDependencyAdapter;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.internal.GradleFileSystemLayout;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;

public class GradleDependencyDeclarationFactory
implements DependencyDeclarationFactory {
    public DeclaredDependencies create(FileSystemLayout fsLayout, ShrinkwrapArtifactResolvingHelper resolvingHelper) {
        GradleDependencyAdapter gradleAdapter = new GradleDependencyAdapter(fsLayout.getRootPath());
        DeclaredDependencies declaredDependencies = gradleAdapter.getProjectDependencies();
        GradleDependencyDeclarationFactory.resolveDependencies(declaredDependencies.getRuntimeExplicitAndTransientDependencies(), resolvingHelper);
        return declaredDependencies;
    }

    public boolean acceptsFsLayout(FileSystemLayout fsLayout) {
        return fsLayout instanceof GradleFileSystemLayout;
    }

    private static void resolveDependencies(Collection<ArtifactSpec> collection, ShrinkwrapArtifactResolvingHelper helper) {
        collection.forEach(spec -> {
            if (spec.file == null) {
                ArtifactSpec resolved = helper.resolve(spec);
                if (resolved != null) {
                    spec.file = resolved.file;
                } else {
                    throw new IllegalStateException("Unable to resolve artifact: " + spec.toString());
                }
            }
        });
    }
}

