/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.infinispan.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.msc.service.ServiceActivator;
import org.wildfly.swarm.config.EJB3;
import org.wildfly.swarm.config.JPA;
import org.wildfly.swarm.config.Undertow;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponent;
import org.wildfly.swarm.infinispan.InfinispanFraction;
import org.wildfly.swarm.infinispan.InfinispanMessages;
import org.wildfly.swarm.infinispan.runtime.CacheActivator;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class InfinispanCustomizer
implements Customizer {
    private static final String DEFAULT = "default";
    private static final String PASSIVATION = "passivation";
    @Inject
    private InfinispanFraction fraction;
    @Inject
    private Instance<Undertow> undertow;
    @Inject
    private Instance<EJB3> ejb;
    @Inject
    private Instance<JPA> jpa;

    public void customize() {
        if (this.fraction.isDefaultFraction()) {
            this.localCustomization();
        }
    }

    private void localCustomization() {
        this.fraction.cacheContainer("server", cc -> cc.defaultCache(DEFAULT).module("org.wildfly.clustering.server").localCache(DEFAULT, c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.BATCH))));
        if (!this.undertow.isUnsatisfied()) {
            this.fraction.cacheContainer("web", cc -> cc.defaultCache(PASSIVATION).module("org.wildfly.clustering.web.infinispan").localCache(PASSIVATION, c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(true)).purge(Boolean.valueOf(false)))));
        }
        if (!this.ejb.isUnsatisfied()) {
            this.fraction.cacheContainer("ejb", cc -> cc.alias("sfsb").defaultCache(PASSIVATION).module("org.wildfly.clustering.ejb.infinispan").localCache(PASSIVATION, c -> c.lockingComponent(lc -> lc.isolation(LockingComponent.Isolation.REPEATABLE_READ)).transactionComponent(tc -> tc.mode(TransactionComponent.Mode.BATCH)).fileStore(fs -> fs.passivation(Boolean.valueOf(true)).purge(Boolean.valueOf(false)))));
        }
        if (!this.jpa.isUnsatisfied()) {
            this.fraction.cacheContainer("hibernate", cc -> cc.module("org.infinispan.hibernate-cache").localCache("entity", c -> c.transactionComponent(t -> t.mode(TransactionComponent.Mode.NON_XA)).objectMemory(om -> om.size(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache("local-query", c -> c.objectMemory(om -> om.size(Long.valueOf(10000L))).expirationComponent(e -> e.maxIdle(Long.valueOf(100000L)))).localCache("timestamps"));
        }
    }

    @Produces
    @Dependent
    public ServiceActivator defaultActivator() {
        return new CacheActivator("server", CacheActivator.Type.DEFAULT_CACHE);
    }

    @Produces
    @Dependent
    public ServiceActivator undertowActivator() {
        return this.createActivatorIfSatisfied(this.undertow, "web", CacheActivator.Type.DEFAULT_CACHE);
    }

    @Produces
    @Dependent
    public ServiceActivator ejbActivator() {
        return this.createActivatorIfSatisfied(this.ejb, "ejb", CacheActivator.Type.DEFAULT_CACHE);
    }

    @Produces
    @Dependent
    public ServiceActivator jpaActivator() {
        return this.createActivatorIfSatisfied(this.jpa, "hibernate", CacheActivator.Type.CACHE_CONTAINER_CONFIGURATION);
    }

    private ServiceActivator createActivatorIfSatisfied(Instance instance, String cacheContainer, CacheActivator.Type type) {
        if (instance.isUnsatisfied()) {
            InfinispanMessages.MESSAGES.skippingCacheActivation(cacheContainer);
            return null;
        }
        return new CacheActivator(cacheContainer, type);
    }
}

