/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management;

import org.wildfly.swarm.config.management.SecurityRealm;
import org.wildfly.swarm.management.InMemoryAuthentication;
import org.wildfly.swarm.management.InMemoryAuthenticationConsumer;
import org.wildfly.swarm.management.InMemoryAuthorization;
import org.wildfly.swarm.management.InMemoryAuthorizationConsumer;
import org.wildfly.swarm.spi.api.annotations.Configurable;

public class EnhancedSecurityRealm
extends SecurityRealm<EnhancedSecurityRealm> {
    public static final String IN_MEMORY_PLUGIN_NAME = "thorntail-in-memory";

    public EnhancedSecurityRealm(String key) {
        super(key);
        this.plugIn("org.wildfly.swarm.management:runtime");
    }

    @Configurable(value="in-memory-authentication")
    public EnhancedSecurityRealm inMemoryAuthentication(InMemoryAuthenticationConsumer consumer) {
        return (EnhancedSecurityRealm)this.plugInAuthentication(plugin -> {
            plugin.name(IN_MEMORY_PLUGIN_NAME);
            InMemoryAuthentication authn = new InMemoryAuthentication(this.getKey(), plugin);
            consumer.accept(authn);
        });
    }

    public EnhancedSecurityRealm inMemoryAuthorization() {
        return this.inMemoryAuthorization(authz -> {});
    }

    @Configurable(value="in-memory-authorization")
    public EnhancedSecurityRealm inMemoryAuthorization(InMemoryAuthorizationConsumer consumer) {
        return (EnhancedSecurityRealm)this.plugInAuthorization(plugin -> {
            plugin.name(IN_MEMORY_PLUGIN_NAME);
            InMemoryAuthorization authz = new InMemoryAuthorization(plugin);
            consumer.accept(authz);
        });
    }
}

