/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management;

import java.util.List;
import java.util.function.Consumer;
import org.wildfly.swarm.config.management.security_realm.PlugInAuthorization;
import org.wildfly.swarm.management.InMemoryUserAuthorization;
import org.wildfly.swarm.spi.api.annotations.Configurable;

@Configurable
public class InMemoryAuthorization {
    private final PlugInAuthorization plugin;

    public InMemoryAuthorization(PlugInAuthorization plugin) {
        this.plugin = plugin;
    }

    public void add(String userName, String ... roles) {
        this.plugin.property(userName + ".roles", prop -> {
            String value = String.join((CharSequence)",", roles);
            prop.value(value);
        });
    }

    public void add(String userName, List<String> roles) {
        this.plugin.property(userName + ".roles", prop -> {
            String value = String.join((CharSequence)",", roles);
            prop.value(value);
        });
    }

    @Configurable
    public InMemoryAuthorization user(String userName, Consumer<InMemoryUserAuthorization> config) {
        InMemoryUserAuthorization authz = new InMemoryUserAuthorization();
        config.accept(authz);
        this.add(userName, authz.roles());
        return this;
    }
}

