/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management;

import javax.annotation.PostConstruct;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.management.EnhancedSecurityRealm;
import org.wildfly.swarm.management.EnhancedSecurityRealmConsumer;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;

@MarshalDMR
@Configurable(value="thorntail.management")
public class ManagementFraction
extends ManagementCoreService<ManagementFraction>
implements Fraction<ManagementFraction> {
    public static final String JSON_FORMATTER = "json-formatter";
    public static final String AUDIT_LOG_FILE = "audit-log.log";
    public static final String FILE_HANDLER = "file";
    @AttributeDocumentation(value="Port for HTTP access to management interface")
    @Configurable(value="thorntail.management.http.port")
    private Defaultable<Integer> httpPort = Defaultable.integer((int)9990);
    @AttributeDocumentation(value="Port for HTTPS access to management interface")
    @Configurable(value="thorntail.management.https.port")
    private Defaultable<Integer> httpsPort = Defaultable.integer((int)9993);
    @AttributeDocumentation(value="Flag to disable HTTP access to management interface")
    @Configurable(value="thorntail.management.http.disable")
    private Defaultable<Boolean> httpDisable = Defaultable.bool((boolean)false);

    public static ManagementFraction createDefaultFraction() {
        return new ManagementFraction().applyDefaults();
    }

    @PostConstruct
    public void postConstruct() {
        this.applyDefaults();
    }

    public ManagementFraction applyDefaults() {
        this.httpInterfaceManagementInterface();
        this.auditAccess(access -> {
            access.jsonFormatter(JSON_FORMATTER, formatter -> {});
            access.fileHandler(FILE_HANDLER, handler -> {
                handler.formatter(JSON_FORMATTER);
                handler.path(AUDIT_LOG_FILE);
                handler.relativeTo("user.dir");
            });
            access.auditLogLogger(logger2 -> {
                logger2.logBoot(Boolean.valueOf(true));
                logger2.logReadOnly(Boolean.valueOf(false));
                logger2.enabled(Boolean.valueOf(false));
                logger2.handler(FILE_HANDLER);
            });
        });
        return this;
    }

    public ManagementFraction httpInterfaceManagementInterface() {
        return this.httpInterfaceManagementInterface(iface -> {});
    }

    public ManagementFraction httpInterfaceManagementInterface(HTTPInterfaceManagementInterfaceConsumer consumer) {
        return (ManagementFraction)super.httpInterfaceManagementInterface(iface -> {
            iface.consoleEnabled(Boolean.valueOf(false));
            iface.httpUpgrade("enabled", (Object)true);
            iface.socketBinding("management-http");
            consumer.accept(iface);
        });
    }

    public ManagementFraction securityRealm(String childKey, EnhancedSecurityRealmConsumer consumer) {
        return (ManagementFraction)this.securityRealm(() -> {
            EnhancedSecurityRealm realm = new EnhancedSecurityRealm(childKey);
            consumer.accept(realm);
            return realm;
        });
    }

    public ManagementFraction httpPort(int port) {
        this.httpPort.set((Object)port);
        return this;
    }

    public int httpPort() {
        return (Integer)this.httpPort.get();
    }

    public ManagementFraction httpsPort(int port) {
        this.httpsPort.set((Object)port);
        return this;
    }

    public int httpsPort() {
        return (Integer)this.httpsPort.get();
    }

    public ManagementFraction httpDisable(boolean httpDisable) {
        this.httpDisable.set((Object)httpDisable);
        return this;
    }

    public boolean isHttpDisable() {
        return (Boolean)this.httpDisable.get();
    }

    public ManagementFraction enableDefaultAuditAccess() {
        this.subresources().auditAccess().subresources().auditLogLogger().enabled(Boolean.valueOf(true));
        return this;
    }
}

