package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceConsumer;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceSupplier;
import org.wildfly.swarm.config.microprofile.config.ConfigSource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceProviderConsumer;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceProviderSupplier;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceProvider;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Eclipse MicroProfile Config Extension with SmallRye
 */
@Address("/subsystem=microprofile-config")
@ResourceType("subsystem")
@Implicit
public class MicroprofileConfig<T extends MicroprofileConfig<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private MicroprofileConfigResources subresources = new MicroprofileConfigResources();

	public MicroprofileConfig() {
		super();
		this.key = "microprofile-config";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public MicroprofileConfigResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ConfigSource objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConfigSource objects.
	 */
	@SuppressWarnings("unchecked")
	public T configSources(java.util.List<ConfigSource> value) {
		this.subresources.configSources = value;
		return (T) this;
	}

	/**
	 * Add the ConfigSource object to the list of subresources
	 * 
	 * @param value
	 *            The ConfigSource to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configSource(ConfigSource value) {
		this.subresources.configSources.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigSource object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ConfigSource resource
	 * @param config
	 *            The ConfigSourceConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configSource(java.lang.String childKey,
			ConfigSourceConsumer consumer) {
		ConfigSource<? extends ConfigSource> child = new ConfigSource<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		configSource(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigSource object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ConfigSource resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configSource(java.lang.String childKey) {
		configSource(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConfigSource object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T configSource(ConfigSourceSupplier supplier) {
		configSource(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ConfigSourceProvider objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConfigSourceProvider objects.
	 */
	@SuppressWarnings("unchecked")
	public T configSourceProviders(java.util.List<ConfigSourceProvider> value) {
		this.subresources.configSourceProviders = value;
		return (T) this;
	}

	/**
	 * Add the ConfigSourceProvider object to the list of subresources
	 * 
	 * @param value
	 *            The ConfigSourceProvider to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configSourceProvider(ConfigSourceProvider value) {
		this.subresources.configSourceProviders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigSourceProvider object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConfigSourceProvider resource
	 * @param config
	 *            The ConfigSourceProviderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configSourceProvider(java.lang.String childKey,
			ConfigSourceProviderConsumer consumer) {
		ConfigSourceProvider<? extends ConfigSourceProvider> child = new ConfigSourceProvider<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		configSourceProvider(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigSourceProvider object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConfigSourceProvider resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configSourceProvider(java.lang.String childKey) {
		configSourceProvider(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConfigSourceProvider object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T configSourceProvider(ConfigSourceProviderSupplier supplier) {
		configSourceProvider(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for MicroprofileConfig
	 */
	public static class MicroprofileConfigResources {
		/**
		 * Config Source
		 */
		@ResourceDocumentation("Config Source")
		@SubresourceInfo("configSource")
		private List<ConfigSource> configSources = new java.util.ArrayList<>();
		/**
		 * Config Source Provider
		 */
		@ResourceDocumentation("Config Source Provider")
		@SubresourceInfo("configSourceProvider")
		private List<ConfigSourceProvider> configSourceProviders = new java.util.ArrayList<>();

		/**
		 * Get the list of ConfigSource resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConfigSource> configSources() {
			return this.configSources;
		}

		public ConfigSource configSource(java.lang.String key) {
			return this.configSources.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ConfigSourceProvider resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConfigSourceProvider> configSourceProviders() {
			return this.configSourceProviders;
		}

		public ConfigSourceProvider configSourceProvider(java.lang.String key) {
			return this.configSourceProviders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}
}