package org.wildfly.swarm.config.microprofile.config;

import org.wildfly.swarm.config.microprofile.config.ConfigSourceProvider;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigSourceProviderConsumer<T extends ConfigSourceProvider<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigSourceProvider resource
	 * 
	 * @parameter Instance of ConfigSourceProvider to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigSourceProviderConsumer<T> andThen(
			ConfigSourceProviderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}