/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.extension.microprofile.config.Registry;
import org.wildfly.extension.microprofile.config.SubsystemExtension;
import org.wildfly.extension.microprofile.config._private.MicroProfileConfigLogger;

class ConfigSourceProviderDefinition
extends PersistentResourceDefinition {
    static ObjectTypeAttributeDefinition CLASS = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"class", (AttributeDefinition[])new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build()}).setAllowNull(false).setAllowNull(true).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).setRestartAllServices()).build();
    static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CLASS};

    protected ConfigSourceProviderDefinition(final Registry<ConfigSourceProvider> providers) {
        super(SubsystemExtension.CONFIG_SOURCE_PROVIDER_PATH, SubsystemExtension.getResourceDescriptionResolver(SubsystemExtension.CONFIG_SOURCE_PROVIDER_PATH.getKey()), (OperationStepHandler)new AbstractAddStepHandler(ATTRIBUTES){

            protected boolean requiresRuntime(OperationContext context) {
                return true;
            }

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                super.performRuntime(context, operation, model);
                String name = context.getCurrentAddressValue();
                ModelNode classModel = CLASS.resolveModelAttribute(context, model);
                if (classModel.isDefined()) {
                    Class configSourceProviderClass = ConfigSourceProviderDefinition.unwrapClass(classModel);
                    try {
                        providers.register(name, ConfigSourceProvider.class.cast(configSourceProviderClass.newInstance()));
                    }
                    catch (Exception e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                }
            }
        }, (OperationStepHandler)new AbstractRemoveStepHandler(){

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
                String name = context.getCurrentAddressValue();
                providers.unregister(name);
            }
        });
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    private static Class<?> unwrapClass(ModelNode classModel) throws OperationFailedException {
        String className = classModel.get("name").asString();
        String moduleName = classModel.get("module").asString();
        try {
            ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)moduleName);
            Module module = Module.getCallerModuleLoader().loadModule(moduleID);
            return module.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw MicroProfileConfigLogger.ROOT_LOGGER.unableToLoadClassFromModule(className, moduleName);
        }
    }
}

