/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config;

import io.smallrye.config.SmallRyeConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.config.ConfigMarkerService;
import org.wildfly.extension.microprofile.config._private.MicroProfileConfigLogger;
import org.wildfly.extension.microprofile.config.deployment.DependencyProcessor;
import org.wildfly.extension.microprofile.config.deployment.SubsystemDeploymentProcessor;

class SubsystemAdd
extends AbstractBoottimeAddStepHandler {
    final Iterable<ConfigSourceProvider> providers;
    final Iterable<ConfigSource> sources;

    SubsystemAdd(Iterable<ConfigSourceProvider> providers, Iterable<ConfigSource> sources) {
        this.providers = providers;
        this.sources = sources;
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) {
        MicroProfileConfigLogger.ROOT_LOGGER.activatingSubsystem();
        ConfigMarkerService.install(context);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("microprofile-config", Phase.DEPENDENCIES, 6224, (DeploymentUnitProcessor)new DependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-config", Phase.POST_MODULE, 14160, (DeploymentUnitProcessor)new SubsystemDeploymentProcessor(SubsystemAdd.this.providers, SubsystemAdd.this.sources));
            }
        }, OperationContext.Stage.RUNTIME);
    }

    static {
        ConfigProviderResolver.setInstance((ConfigProviderResolver)new SmallRyeConfigProviderResolver());
    }
}

