/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.deployment;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class SubsystemDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<Config> CONFIG = AttachmentKey.create(Config.class);
    private final Iterable<ConfigSourceProvider> providers;
    private final Iterable<ConfigSource> sources;

    public SubsystemDeploymentProcessor(Iterable<ConfigSourceProvider> providers, Iterable<ConfigSource> sources) {
        this.providers = providers;
        this.sources = sources;
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.forClassLoader((ClassLoader)module.getClassLoader()).addDefaultSources().addDiscoveredSources().addDiscoveredConverters();
        ModuleClassLoader loader = module.getClassLoader();
        for (ConfigSourceProvider provider : this.providers) {
            for (ConfigSource source : provider.getConfigSources((ClassLoader)loader)) {
                builder.withSources(new ConfigSource[]{source});
            }
        }
        for (ConfigSource source : this.sources) {
            builder.withSources(new ConfigSource[]{source});
        }
        SmallRyeConfig config = builder.build();
        deploymentUnit.putAttachment(CONFIG, (Object)config);
        ConfigProviderResolver.instance().registerConfig((Config)config, (ClassLoader)module.getClassLoader());
    }

    public void undeploy(DeploymentUnit context) {
        Config config = (Config)context.removeAttachment(CONFIG);
        ConfigProviderResolver.instance().releaseConfig(config);
    }
}

