/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class MiniConProp {
    private MiniConProp() {
    }

    public static ExecutorService executorService(ContextProvider contextProvider, ExecutorService delegate) {
        return new ConPropExecutorService(contextProvider, delegate);
    }

    public static ScheduledExecutorService scheduledExecutorService(ContextProvider contextProvider, ScheduledExecutorService delegate) {
        return new ConPropScheduledExecutorService(contextProvider, delegate);
    }

    private static class ConPropScheduledExecutorService
    extends ConPropExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService delegate;

        ConPropScheduledExecutorService(ContextProvider contextProvider, ScheduledExecutorService delegate) {
            super(contextProvider, delegate);
            this.delegate = delegate;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            return this.delegate.schedule(new ConPropRunnable(contextSnapshot, command), delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            return this.delegate.schedule(new ConPropCallable<V>(contextSnapshot, callable), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            return this.delegate.scheduleAtFixedRate(new ConPropRunnable(contextSnapshot, command), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            return this.delegate.scheduleWithFixedDelay(new ConPropRunnable(contextSnapshot, command), initialDelay, delay, unit);
        }
    }

    private static class ConPropExecutorService
    implements ExecutorService {
        protected final ContextProvider contextProvider;
        private final ExecutorService delegate;

        ConPropExecutorService(ContextProvider contextProvider, ExecutorService delegate) {
            this.contextProvider = contextProvider;
            this.delegate = delegate;
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            return this.delegate.submit(new ConPropCallable<T>(contextSnapshot, task));
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            return this.delegate.submit(new ConPropRunnable(contextSnapshot, task), result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            return this.delegate.submit(new ConPropRunnable(contextSnapshot, task));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            ArrayList<ConPropCallable<T>> conPropTasks = new ArrayList<ConPropCallable<T>>(tasks.size());
            for (Callable<T> task : tasks) {
                conPropTasks.add(new ConPropCallable<T>(contextSnapshot, task));
            }
            return this.delegate.invokeAll(conPropTasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            ArrayList<ConPropCallable<T>> conPropTasks = new ArrayList<ConPropCallable<T>>(tasks.size());
            for (Callable<T> task : tasks) {
                conPropTasks.add(new ConPropCallable<T>(contextSnapshot, task));
            }
            return this.delegate.invokeAll(conPropTasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            ArrayList<ConPropCallable<T>> conPropTasks = new ArrayList<ConPropCallable<T>>(tasks.size());
            for (Callable<T> task : tasks) {
                conPropTasks.add(new ConPropCallable<T>(contextSnapshot, task));
            }
            return this.delegate.invokeAny(conPropTasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            ArrayList<ConPropCallable<T>> conPropTasks = new ArrayList<ConPropCallable<T>>(tasks.size());
            for (Callable<T> task : tasks) {
                conPropTasks.add(new ConPropCallable<T>(contextSnapshot, task));
            }
            return this.delegate.invokeAny(conPropTasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            ContextSnapshot contextSnapshot = this.contextProvider.capture();
            this.delegate.execute(new ConPropRunnable(contextSnapshot, command));
        }
    }

    private static final class ConPropCallable<V>
    implements Callable<V> {
        private final ContextSnapshot contextSnapshot;
        private final Callable<V> delegate;

        ConPropCallable(ContextSnapshot contextSnapshot, Callable<V> delegate) {
            this.contextSnapshot = contextSnapshot;
            this.delegate = delegate;
        }

        @Override
        public V call() throws Exception {
            ActiveContextSnapshot activeSnapshot = this.contextSnapshot.activate();
            try {
                V v = this.delegate.call();
                return v;
            }
            finally {
                activeSnapshot.deactivate();
            }
        }
    }

    private static final class ConPropRunnable
    implements Runnable {
        private final ContextSnapshot contextSnapshot;
        private final Runnable delegate;

        ConPropRunnable(ContextSnapshot contextSnapshot, Runnable delegate) {
            this.contextSnapshot = contextSnapshot;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            ActiveContextSnapshot activeSnapshot = this.contextSnapshot.activate();
            try {
                this.delegate.run();
            }
            finally {
                activeSnapshot.deactivate();
            }
        }
    }

    private static final class CompoundContextProvider
    implements ContextProvider {
        private final List<ContextProvider> contextProviders;

        CompoundContextProvider(List<ContextProvider> contextProviders) {
            this.contextProviders = contextProviders;
        }

        @Override
        public ContextSnapshot capture() {
            ArrayList<ContextSnapshot> snapshots = new ArrayList<ContextSnapshot>();
            for (ContextProvider contextProvider : this.contextProviders) {
                snapshots.add(contextProvider.capture());
            }
            return () -> {
                ArrayList<ActiveContextSnapshot> activeSnapshots = new ArrayList<ActiveContextSnapshot>();
                for (ContextSnapshot snapshot : snapshots) {
                    activeSnapshots.add(snapshot.activate());
                }
                return () -> {
                    for (int i = activeSnapshots.size() - 1; i >= 0; --i) {
                        ((ActiveContextSnapshot)activeSnapshots.get(i)).deactivate();
                    }
                };
            };
        }
    }

    @FunctionalInterface
    public static interface ActiveContextSnapshot {
        public static final ActiveContextSnapshot NOOP = () -> {};

        public void deactivate();
    }

    @FunctionalInterface
    public static interface ContextSnapshot {
        public static final ContextSnapshot NOOP = () -> ActiveContextSnapshot.NOOP;

        public ActiveContextSnapshot activate();
    }

    @FunctionalInterface
    public static interface ContextProvider {
        public static final ContextProvider NOOP = () -> ContextSnapshot.NOOP;

        public ContextSnapshot capture();

        public static ContextProvider compound(ContextProvider ... contextProviders) {
            return new CompoundContextProvider(Arrays.asList(contextProviders));
        }
    }
}

