/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import io.smallrye.faulttolerance.DefaultExecutorFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.naming.InitialContext;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.MiniConProp;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.TracingContextProvider;

public class ThorntailExecutorFactory
extends DefaultExecutorFactory {
    private final boolean tracingIntegrationRequired = TracingContextProvider.isRequired();

    public ExecutorService createCoreExecutor(int size) {
        ExecutorService baseExecutor = super.createCoreExecutor(size);
        if (this.tracingIntegrationRequired) {
            return MiniConProp.executorService(TracingContextProvider.INSTANCE, baseExecutor);
        }
        return baseExecutor;
    }

    public ExecutorService createExecutor(int coreSize, int size) {
        ExecutorService baseExecutor = super.createExecutor(coreSize, size);
        if (this.tracingIntegrationRequired) {
            return MiniConProp.executorService(TracingContextProvider.INSTANCE, baseExecutor);
        }
        return baseExecutor;
    }

    public ScheduledExecutorService createTimeoutExecutor(int size) {
        ScheduledExecutorService baseExecutor = super.createTimeoutExecutor(size);
        if (this.tracingIntegrationRequired) {
            return MiniConProp.scheduledExecutorService(TracingContextProvider.INSTANCE, baseExecutor);
        }
        return baseExecutor;
    }

    protected ThreadFactory threadFactory() {
        try {
            InitialContext initialContext = new InitialContext();
            return (ThreadFactory)initialContext.lookup("java:jboss/ee/concurrency/factory/default");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int priority() {
        return 10;
    }
}

