/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.MiniConProp;

final class TracingContextProvider
implements MiniConProp.ContextProvider {
    static final TracingContextProvider INSTANCE = new TracingContextProvider();

    TracingContextProvider() {
    }

    public static boolean isRequired() {
        try {
            Class.forName("io.opentracing.Tracer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public MiniConProp.ContextSnapshot capture() {
        Tracer tracer = GlobalTracer.get();
        ScopeManager scopeManager = tracer.scopeManager();
        Scope activeScope = scopeManager.active();
        if (activeScope != null) {
            Span span = activeScope.span();
            return () -> {
                Scope propagated = scopeManager.activate(span, false);
                return () -> ((Scope)propagated).close();
            };
        }
        return MiniConProp.ContextSnapshot.NOOP;
    }
}

