/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.health.deployment;

import io.smallrye.health.SmallRyeHealthReporter;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.Unmanaged;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.health.api.Monitor;

public class HealthExtension
implements Extension {
    private static Logger log = Logger.getLogger(HealthExtension.class);
    private final Monitor monitor;
    private AnnotatedType<?> delegate;
    private Unmanaged.UnmanagedInstance<SmallRyeHealthReporter> reporterInstance;
    private SmallRyeHealthReporter reporter;

    public HealthExtension() {
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public void observeResources(@Observes ProcessAnnotatedType<SmallRyeHealthReporter> event) {
        this.delegate = event.getAnnotatedType();
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation abd, BeanManager beanManager) {
        try {
            if (this.delegate != null) {
                Unmanaged unmanagedHealthCheck = new Unmanaged(beanManager, SmallRyeHealthReporter.class);
                this.reporterInstance = unmanagedHealthCheck.newInstance();
                this.reporter = (SmallRyeHealthReporter)this.reporterInstance.produce().inject().postConstruct().get();
                this.monitor.registerHealthReporter(this.reporter);
                this.monitor.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
                log.info((Object)(">> Added health reporter bean " + this.reporter));
                this.delegate = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register health reporter bean", e);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        this.monitor.unregisterHealthReporter();
        this.monitor.unregisterContextClassLoader();
        this.reporter = null;
        this.reporterInstance.preDestroy().dispose();
        this.reporterInstance = null;
    }
}

