/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.health.runtime;

import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.inject.Vetoed;
import javax.naming.NamingException;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.swarm.microprofile.health.api.Monitor;

@Vetoed
public class HttpContexts
implements HttpHandler {
    public static final String LCURL = "{";
    public static final String RCURL = "}";
    static AttachmentKey<String> TOKEN = AttachmentKey.create(String.class);
    public static final String NODE = "/node";
    public static final String HEAP = "/heap";
    public static final String THREADS = "/threads";
    public static final String HEALTH = "/health";
    public static final String HEALTH_LIVE = "/health/live";
    public static final String HEALTH_READY = "/health/ready";
    static final String EPHEMERAL_TOKEN = UUID.randomUUID().toString();
    private final Monitor monitor;
    private final HttpHandler next;

    public HttpContexts(HttpHandler next) {
        this.next = next;
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (NODE.equals(exchange.getRequestPath())) {
            this.nodeInfo(exchange);
            return;
        }
        if (HEAP.equals(exchange.getRequestPath())) {
            this.heap(exchange);
            return;
        }
        if (THREADS.equals(exchange.getRequestPath())) {
            this.threads(exchange);
            return;
        }
        if (HEALTH.equals(exchange.getRequestPath())) {
            this.health(exchange, SmallRyeHealthReporter::getHealth, this::defaultUpHealthInfo);
            return;
        }
        if (HEALTH_LIVE.equals(exchange.getRequestPath())) {
            this.health(exchange, SmallRyeHealthReporter::getLiveness, this::defaultUpHealthInfo);
            return;
        }
        if (HEALTH_READY.equals(exchange.getRequestPath())) {
            this.health(exchange, SmallRyeHealthReporter::getReadiness, this::defaultDownHealthInfo);
            return;
        }
        this.next.handleRequest(exchange);
    }

    private void responseHeaders(HttpServerExchange exchange) {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Origin"), "*");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Headers"), "origin, content-type, accept, authorization");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Credentials"), "true");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Methods"), "GET, POST, PUT, DELETE, OPTIONS, HEAD");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Max-Age"), "1209600");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void health(HttpServerExchange exchange, Function<SmallRyeHealthReporter, SmallRyeHealth> healthFunction, Consumer<HttpServerExchange> defaultHealthInfo) {
        if (this.monitor.getHealthReporter() != null) {
            SmallRyeHealth health;
            SmallRyeHealthReporter reporter = (SmallRyeHealthReporter)this.monitor.getHealthReporter();
            ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.monitor.getContextClassLoader());
                health = healthFunction.apply(reporter);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
            if (health.isDown()) {
                exchange.setStatusCode(503);
            } else {
                exchange.setStatusCode(200);
            }
            this.responseHeaders(exchange);
            exchange.getResponseSender().send(health.getPayload().toString());
            exchange.endExchange();
        } else {
            defaultHealthInfo.accept(exchange);
        }
    }

    private void defaultUpHealthInfo(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        this.responseHeaders(exchange);
        exchange.getResponseSender().send("{\"status\":\"UP\", \"checks\":[]}");
        exchange.endExchange();
    }

    private void defaultDownHealthInfo(HttpServerExchange exchange) {
        exchange.setStatusCode(503);
        this.responseHeaders(exchange);
        exchange.getResponseSender().send("{\"status\":\"DOWN\", \"checks\":[]}");
        exchange.endExchange();
    }

    private void nodeInfo(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.getNodeInfo().toJSONString(false));
    }

    private void heap(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.heap().toJSONString(false));
    }

    private void threads(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.threads().toJSONString(false));
    }

    public static List<String> getDefaultContextNames() {
        return Arrays.asList(NODE, HEAP, HEALTH, THREADS);
    }
}

