/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth;

import java.util.Map;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.Configurables;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;

@Configurable(value="thorntail.microprofile.jwt")
@DeploymentModule(name="org.wildfly.swarm.microprofile.jwtauth", slot="deployment", export=true, metaInf=DeploymentModule.MetaInfDisposition.IMPORT)
public class MicroProfileJWTAuthFraction
implements Fraction<MicroProfileJWTAuthFraction> {
    @AttributeDocumentation(value="The URI of the JWT token issuer")
    @Configurables(value={@Configurable(value="thorntail.microprofile.jwt.token.issued-by"), @Configurable(value="thorntail.microprofile.jwtauth.token.issuedBy")})
    private Defaultable<String> tokenIssuer = Defaultable.string((String)"http://localhost");
    @AttributeDocumentation(value="The public key of the JWT token signer. Can be prefixed 'file:' or 'classpath:' to refer to external assets, but this is deprecated; use 'thorntail.microprofile.jwt.token.signer-pub-key-location' instead")
    @Configurables(value={@Configurable(value="thorntail.microprofile.jwt.token.signer-pub-key"), @Configurable(value="thorntail.microprofile.jwtauth.token.signerPubKey")})
    private String publicKey;
    @AttributeDocumentation(value="Location of the public key of the JWT token signer. By default, or when the 'classpath:' prefix is present, this is a classpath resource. Can be prefixed with 'file:' to refer to an external file. Can also be a HTTPS URL of a JWK Set.")
    @Configurable(value="thorntail.microprofile.jwt.token.signer-pub-key-location")
    private String publicKeyLocation;
    @AttributeDocumentation(value="The JWT token expiration grace period in seconds ")
    @Configurables(value={@Configurable(value="thorntail.microprofile.jwt.token.exp-grace-period"), @Configurable(value="thorntail.microprofile.jwtauth.token.expGracePeriod")})
    private Defaultable<Integer> expGracePeriodSecs = Defaultable.integer((int)60);
    @AttributeDocumentation(value="The JWKS URI from which to load public keys. This property is deprecated, use the 'thorntail.microprofile.jwt.token.signer-pub-key-location' property instead")
    @Configurable(value="thorntail.microprofile.jwt.token.jwks-uri")
    @Deprecated
    private String jwksUri;
    @AttributeDocumentation(value="The interval at which the JWKS URI should be queried for keys (in minutes). It is ignored if the value of either signer-pub-key-location or jwks-uri is not HTTPS URI")
    @Configurable(value="thorntail.microprofile.jwt.token.jwks-refresh-interval")
    private Defaultable<Integer> jwksRefreshInterval = Defaultable.integer((int)60);
    @AttributeDocumentation(value="If a JAX-RS resource has no class-level security metadata, then if this property is set to `true` and at least one resource method has security metadata all other resource methods without security metadata have an implicit `@DenyAll`, otherwise resource methods without security metadata are not secured")
    @Configurable(value="thorntail.microprofile.jwt.default-missing-method-permissions-deny-access")
    private Defaultable<Boolean> defaultMissingMethodPermissionsDenyAccess = Defaultable.bool((boolean)true);
    @AttributeDocumentation(value="HTTP header which is expected to contain a JWT token, default value is 'Authorization'")
    @Configurable(value="thorntail.microprofile.jwt.token.header")
    private Defaultable<String> tokenHeader = Defaultable.string((String)"Authorization");
    @AttributeDocumentation(value="Cookie name containing a JWT token. This property is ignored unless the 'thorntail.microprofile.jwt.token.header' is set to 'Cookie'")
    @Configurable(value="thorntail.microprofile.jwt.token.cookie")
    private String tokenCookie;
    @AttributeDocumentation(value="Default group name. This property can be used to support the JWT tokens without a 'groups' claim.")
    @Configurable(value="thorntail.microprofile.jwt.claims.groups")
    private String defaultGroupsClaim;
    @AttributeDocumentation(value="Path to the claim containing an array of groups, for example: 'realm/groups'. It can be used if a token has no 'groups' claim but has the groups set in a different claim")
    @Configurable(value="thorntail.microprofile.jwt.path.groups")
    private String groupsPath;
    @Configurables(value={@Configurable(value="thorntail.microprofile.jwt.realm"), @Configurable(value="thorntail.microprofile.jwtauth.realm")})
    @AttributeDocumentation(value="Defines the security domain which should be used for MicroProfile JWT. If no security domain with this name exists, one will be created using sensible defaults.  If this option is set, then the @LoginConfig annotation is not needed but if it is present then its realmName property, if set, must have the same value as this option.")
    private Defaultable<String> jwtRealm = Defaultable.string((String)"");
    @Configurables(value={@Configurable(value="thorntail.microprofile.jwt.roles.file"), @Configurable(value="thorntail.microprofile.jwtauth.roles.file")})
    @AttributeDocumentation(value="Roles properties file path, ignored if the roles.map property is set")
    private Defaultable<String> rolesPropertiesFile = Defaultable.string((String)"");
    @Configurables(value={@Configurable(value="thorntail.microprofile.jwt.roles.map"), @Configurable(value="thorntail.microprofile.jwtauth.roles.map")})
    @AttributeDocumentation(value="Roles properties map")
    private Map<String, String> rolesPropertiesMap;
    @AttributeDocumentation(value="Set this to false to disable the MP JWT authentication mechanism. Defaults to true.")
    @Configurable(value="thorntail.microprofile.jwt.enabled")
    private Defaultable<Boolean> jwtEnabled = Defaultable.bool((boolean)true);

    public Defaultable<Boolean> isJwtEnabled() {
        return this.jwtEnabled;
    }

    public void setJwtEnabled(boolean enabled) {
        this.jwtEnabled = Defaultable.bool((boolean)enabled);
    }

    public Defaultable<String> getTokenIssuer() {
        return this.tokenIssuer;
    }

    public void setTokenIssuer(Defaultable<String> tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPublicKeyLocation() {
        return this.publicKeyLocation;
    }

    public void setPublicKeyLocation(String publicKeyLocation) {
        this.publicKeyLocation = publicKeyLocation;
    }

    public Defaultable<Integer> getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public void setExpGracePeriodSecs(Defaultable<Integer> expGracePeriodSecs) {
        this.expGracePeriodSecs = expGracePeriodSecs;
    }

    @Deprecated
    public String getJwksUri() {
        return this.jwksUri;
    }

    @Deprecated
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public Defaultable<Integer> getJwksRefreshInterval() {
        return this.jwksRefreshInterval;
    }

    public void setJwksRefreshInterval(Defaultable<Integer> jwksRefreshInterval) {
        this.jwksRefreshInterval = jwksRefreshInterval;
    }

    public boolean isDefaultMissingMethodPermissionsDenyAccess() {
        return (Boolean)this.defaultMissingMethodPermissionsDenyAccess.get();
    }

    public Defaultable<String> getTokenHeader() {
        return this.tokenHeader;
    }

    public void setTokenHeader(Defaultable<String> tokenHeader) {
        this.tokenHeader = tokenHeader;
    }

    public String getTokenCookie() {
        return this.tokenCookie;
    }

    public void setTokenCookie(String tokenCookie) {
        this.tokenCookie = tokenCookie;
    }

    public String getDefaultGroupsClaim() {
        return this.defaultGroupsClaim;
    }

    public void setDefaultGroupsClaim(String defaultGroupsClaim) {
        this.defaultGroupsClaim = defaultGroupsClaim;
    }

    public String getGroupsPath() {
        return this.groupsPath;
    }

    public void setGroupsPath(String groupsPath) {
        this.groupsPath = groupsPath;
    }

    public Defaultable<String> getJwtRealm() {
        return this.jwtRealm;
    }

    public void setJwtRealm(Defaultable<String> jwtRealm) {
        this.jwtRealm = jwtRealm;
    }

    public Defaultable<String> getRolesPropertiesFile() {
        return this.rolesPropertiesFile;
    }

    public void setRolesPropertiesFile(Defaultable<String> rolesPropertiesFile) {
        this.rolesPropertiesFile = rolesPropertiesFile;
    }

    public Map<String, String> getRolesPropertiesMap() {
        return this.rolesPropertiesMap;
    }

    public void setRolesPropertiesMap(Map<String, String> rolesPropertiesMap) {
        this.rolesPropertiesMap = rolesPropertiesMap;
    }
}

