/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth;

import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.undertow.UndertowLogger;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Headers;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Optional;
import javax.enterprise.inject.spi.CDI;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.jaas.JWTCredential;

public class JWTAuthMechanism
implements AuthenticationMechanism {
    private JWTAuthContextInfo authContextInfo;
    private IdentityManager identityManager;

    public JWTAuthMechanism(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        String jwtToken = new UndertowBearerTokenExtractor(this.authContextInfo, exchange).getBearerToken();
        if (jwtToken != null) {
            try {
                this.identityManager = securityContext.getIdentityManager();
                JWTCredential credential = new JWTCredential(jwtToken, this.authContextInfo);
                Account account = this.identityManager.verify(credential.getName(), (Credential)credential);
                if (account != null) {
                    JsonWebToken jwtPrincipal = (JsonWebToken)account.getPrincipal();
                    this.preparePrincipalProducer(jwtPrincipal);
                    securityContext.authenticationComplete(account, "MP-JWT", false);
                    org.jboss.security.SecurityContext jbSC = SecurityContextAssociation.getSecurityContext();
                    Subject subject = jbSC.getUtil().getSubject();
                    jbSC.getUtil().createSubjectInfo((Principal)jwtPrincipal, (Object)jwtToken, subject);
                    RoleGroup roles = this.extract(subject);
                    jbSC.getUtil().setRoles(roles);
                    UndertowLogger.SECURITY_LOGGER.debugf("Authenticated caller(%s) for path(%s) with roles: %s", (Object)credential.getName(), (Object)exchange.getRequestPath(), (Object)account.getRoles());
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                UndertowLogger.SECURITY_LOGGER.info((Object)"Failed to authenticate JWT bearer token");
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            catch (Exception e) {
                UndertowLogger.SECURITY_LOGGER.infof((Throwable)e, "Failed to validate JWT bearer token", new Object[0]);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private void preparePrincipalProducer(JsonWebToken jwtPrincipal) {
        PrincipalProducer principalProducer = (PrincipalProducer)CDI.current().select(PrincipalProducer.class, new Annotation[0]).get();
        principalProducer.setJsonWebToken(jwtPrincipal);
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, "Bearer {token}");
        UndertowLogger.SECURITY_LOGGER.debugf("Sending Bearer {token} challenge for %s", (Object)exchange);
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    protected RoleGroup extract(Subject subject) {
        Optional<Principal> match = subject.getPrincipals().stream().filter(g -> g.getName().equals("Roles")).findFirst();
        Group rolesGroup = (Group)match.get();
        SimpleRoleGroup roles = new SimpleRoleGroup(rolesGroup);
        return roles;
    }

    private static class UndertowBearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private HttpServerExchange httpExchange;

        UndertowBearerTokenExtractor(JWTAuthContextInfo authContextInfo, HttpServerExchange exchange) {
            super(authContextInfo);
            this.httpExchange = exchange;
        }

        protected String getHeaderValue(String headerName) {
            return this.httpExchange.getRequestHeaders().getFirst(headerName);
        }

        protected String getCookieValue(String cookieName) {
            Cookie cookie = (Cookie)this.httpExchange.getRequestCookies().get(cookieName);
            return cookie != null ? cookie.getValue() : null;
        }
    }
}

