/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.handlers.form.FormParserFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.JWTAuthMechanism;

@ApplicationScoped
public class JWTAuthMechanismFactory
implements AuthenticationMechanismFactory {
    private static Logger log = Logger.getLogger(JWTAuthMechanismFactory.class);

    @PostConstruct
    public void init() {
        log.debugf("init", new Object[0]);
    }

    public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
        JWTAuthContextInfo contextInfo;
        Optional<Object> optContextInfo = Optional.empty();
        try {
            Instance contextInfoInstance = CDI.current().select(JWTAuthContextInfo.class, new Annotation[0]);
            contextInfo = (JWTAuthContextInfo)contextInfoInstance.get();
            optContextInfo = Optional.of(contextInfo);
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Unable to select JWTAuthContextInfo provider", new Object[0]);
        }
        if (!optContextInfo.isPresent()) {
            String groupsPath;
            String defaultGroupsClaim;
            String tokenCookie;
            String tokenHeader;
            String publicKeyPemEnc;
            contextInfo = new JWTAuthContextInfo();
            String issuedBy = this.getResource(properties, "issuedBy", "MP-JWT-ISSUER");
            if (issuedBy != null) {
                contextInfo.setIssuedBy(issuedBy);
            }
            if ((publicKeyPemEnc = this.getResource(properties, "signerPubKey", "MP-JWT-SIGNER")) == null) {
                String publicKeyLocation = this.getResource(properties, "signerPubKeyLocation", "MP-JWT-SIGNER-KEY-LOCATION");
                if (publicKeyLocation == null) {
                    publicKeyLocation = this.getResource(properties, "jwksUri", "MP-JWT-SIGNER-KEY-LOCATION");
                }
                if (publicKeyLocation != null) {
                    String jwksRefreshInterval;
                    contextInfo.setPublicKeyLocation(publicKeyLocation);
                    if (publicKeyLocation.startsWith("https:") && (jwksRefreshInterval = this.getResource(properties, "jwksRefreshInterval", "MP-JWT-JWKS-REFRESH")) != null) {
                        contextInfo.setJwksRefreshInterval(Integer.valueOf(jwksRefreshInterval));
                    }
                } else {
                    log.debug((Object)"Neither a key content nor a key location was set.");
                }
            } else {
                String publicKeyPem = publicKeyPemEnc.replace(' ', '+');
                try {
                    RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey((String)publicKeyPem);
                    contextInfo.setSignerKey(pk);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            String expGracePeriod = this.getResource(properties, "expGracePeriod", "MP-JWT-EXP-GRACE");
            if (expGracePeriod != null) {
                contextInfo.setExpGracePeriodSecs(Integer.parseInt(expGracePeriod));
            }
            if ((tokenHeader = this.getResource(properties, "tokenHeader", "MP-JWT-TOKEN-HEADER")) != null) {
                contextInfo.setTokenHeader(tokenHeader);
            }
            if ((tokenCookie = this.getResource(properties, "tokenCookie", "MP-JWT-TOKEN-COOKIE")) != null) {
                if (!"Cookie".equals(tokenHeader)) {
                    log.warn((Object)"Token header is not 'Cookie', the cookie name value will be ignored");
                } else {
                    contextInfo.setTokenCookie(tokenCookie);
                }
            }
            if ((defaultGroupsClaim = this.getResource(properties, "defaultGroupsClaim", "MP-JWT-DEFAULT-GROUPS-CLAIM")) != null) {
                contextInfo.setDefaultGroupsClaim(defaultGroupsClaim);
            }
            if ((groupsPath = this.getResource(properties, "groupsPath", "MP-JWT-GROUPS-PATH")) != null) {
                contextInfo.setGroupsPath(groupsPath);
            }
        } else {
            contextInfo = (JWTAuthContextInfo)optContextInfo.get();
        }
        return new JWTAuthMechanism(contextInfo);
    }

    private String getResource(Map<String, String> properties, String propName, String metaInfName) {
        URL valueURL;
        String value = properties.get(propName);
        if (value == null && (valueURL = Thread.currentThread().getContextClassLoader().getResource("/META-INF/" + metaInfName)) != null) {
            value = this.readURLContent(valueURL);
        }
        if (value == null) {
            log.debug((Object)("No " + propName + " parameter was found"));
        }
        return value;
    }

    private String readURLContent(URL url) {
        StringBuilder content = new StringBuilder();
        try {
            InputStream is = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                content.append(line);
                content.append('\n');
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            log.warnf("Failed to read content from: %s, error=%s", (Object)url, (Object)e.getMessage());
        }
        return content.toString().trim();
    }
}

