/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.config;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.SmallryeJwtUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Dependent
public class JWTAuthContextInfoProvider
extends io.smallrye.jwt.config.JWTAuthContextInfoProvider {
    private static final String NONE = "NONE";
    private static final Logger log = Logger.getLogger(JWTAuthContextInfoProvider.class);
    @Inject
    @ConfigProperty(name="mpjwt.signerPublicKey", defaultValue="NONE")
    private Optional<String> publicKeyPemEnc;
    @Inject
    @ConfigProperty(name="mpjwt.issuedBy", defaultValue="NONE")
    private String issuedBy;
    @Inject
    @ConfigProperty(name="mpjwt.expGracePeriodSecs", defaultValue="60")
    private Optional<Integer> expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="mpjwt.jwksUri", defaultValue="NONE")
    private Optional<String> jwksUri;
    @Inject
    @ConfigProperty(name="mpjwt.jwksRefreshInterval", defaultValue="60")
    private Optional<Integer> jwksRefreshInterval;

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        Optional mpJwtLocation;
        log.debugf("init, publicKeyPemEnc=%s, issuedBy=%s, expGracePeriodSecs=%d, jwksRefreshInterval=%d", new Object[]{this.publicKeyPemEnc.orElse("missing"), this.issuedBy, this.expGracePeriodSecs.get(), this.jwksRefreshInterval.get()});
        if (NONE.equals(this.publicKeyPemEnc.get()) && NONE.equals(this.jwksUri.get()) && NONE.equals(super.getMpJwtPublicKey().get()) && NONE.equals(super.getMpJwtLocation().get())) {
            return Optional.empty();
        }
        log.warn((Object)"The use of all mpjwt.* properties is deprecated, use thorntail.microprofile.jwt.* properties instead");
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        if (super.getMpJwtPublicKey().isPresent() && !NONE.equals(super.getMpJwtPublicKey().get())) {
            super.decodeMpJwtPublicKey(contextInfo);
        } else if (this.publicKeyPemEnc.isPresent() && !NONE.equals(this.publicKeyPemEnc.get())) {
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey((String)this.publicKeyPemEnc.get());
                contextInfo.setSignerKey(pk);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        String mpJwtIssuer = super.getMpJwtIssuer();
        if (mpJwtIssuer != null && !mpJwtIssuer.equals(NONE)) {
            contextInfo.setIssuedBy(mpJwtIssuer);
        } else if (this.issuedBy != null && !this.issuedBy.equals(NONE)) {
            contextInfo.setIssuedBy(this.issuedBy);
        }
        Optional mpJwtRequireIss = super.getMpJwtRequireIss();
        if (mpJwtRequireIss != null && mpJwtRequireIss.isPresent()) {
            contextInfo.setRequireIssuer(((Boolean)mpJwtRequireIss.get()).booleanValue());
        } else {
            contextInfo.setRequireIssuer(true);
        }
        if (this.expGracePeriodSecs.isPresent()) {
            contextInfo.setExpGracePeriodSecs(this.expGracePeriodSecs.get().intValue());
        }
        if ((mpJwtLocation = super.getMpJwtLocation()).isPresent() && !NONE.equals(mpJwtLocation.get())) {
            contextInfo.setPublicKeyLocation((String)super.getMpJwtLocation().get());
        } else if (this.jwksUri.isPresent() && !NONE.equals(this.jwksUri.get())) {
            contextInfo.setPublicKeyLocation(this.jwksUri.get());
        }
        if (this.jwksRefreshInterval.isPresent()) {
            contextInfo.setJwksRefreshInterval(this.jwksRefreshInterval.get());
        }
        if (super.getTokenHeader() != null) {
            contextInfo.setTokenHeader(super.getTokenHeader());
        }
        SmallryeJwtUtils.setContextTokenCookie((JWTAuthContextInfo)contextInfo, (Optional)super.getTokenCookie());
        if (super.getDefaultGroupsClaim() != null && super.getDefaultGroupsClaim().isPresent()) {
            contextInfo.setDefaultGroupsClaim((String)super.getDefaultGroupsClaim().get());
        }
        return Optional.of(contextInfo);
    }

    @Produces
    JWTAuthContextInfo getJWTAuthContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

