/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.runtime;

import io.smallrye.jwt.auth.jaxrs.JWTAuthorizationFilterRegistrar;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.microprofile.jwtauth.MicroProfileJWTAuthFraction;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.JBossWebAsset;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class MPJWTAuthExtensionArchivePreparer
implements DeploymentProcessor {
    public static final String RESTEASY_PROVIDERS = "resteasy.providers";
    private static Logger log = Logger.getLogger(MPJWTAuthExtensionArchivePreparer.class);
    private static final String MP_JWT_AUTH_METHOD = "MP-JWT";
    private static final DotName LOGIN_CONFIG = DotName.createSimple((String)"org.eclipse.microprofile.auth.LoginConfig");
    private final Archive archive;
    private final IndexView index;
    @Inject
    private MicroProfileJWTAuthFraction fraction;

    @Inject
    public MPJWTAuthExtensionArchivePreparer(Archive archive, IndexView index) {
        this.archive = archive;
        this.index = index;
    }

    public void process() throws Exception {
        if (!((Boolean)this.fraction.isJwtEnabled().get()).booleanValue()) {
            return;
        }
        WARArchive war = (WARArchive)this.archive.as(WARArchive.class);
        Collection lcAnnotations = this.index.getAnnotations(LOGIN_CONFIG);
        boolean loginConfigMpJwtAvailable = false;
        for (AnnotationInstance lc : lcAnnotations) {
            AnnotationValue authMethod = lc.value("authMethod");
            AnnotationValue realmNameProp = lc.value("realmName");
            String realm = null;
            if (realmNameProp == null) {
                realm = (String)this.fraction.getJwtRealm().get();
            } else {
                if (!((String)this.fraction.getJwtRealm().get()).isEmpty() && !((String)this.fraction.getJwtRealm().get()).equals(realmNameProp.asString())) {
                    log.errorf("LoginConfig realmName %s and 'thorntail.microprofile.jwt.realm' %s values must be equal", this.fraction.getJwtRealm().get(), (Object)realmNameProp.asString());
                    return;
                }
                realm = realmNameProp.asString();
            }
            if (authMethod == null || !MP_JWT_AUTH_METHOD.equals(authMethod.asString()) || realm.length() <= 0) continue;
            this.selectSecurityDomain(war, realm);
            loginConfigMpJwtAvailable = true;
        }
        if (!loginConfigMpJwtAvailable) {
            if (!((String)this.fraction.getJwtRealm().get()).isEmpty()) {
                this.selectSecurityDomain(war, (String)this.fraction.getJwtRealm().get());
            } else {
                return;
            }
        }
        if (this.fraction.getTokenIssuer().isPresent()) {
            log.debugf("Issuer: %s", this.fraction.getTokenIssuer().get());
            war.addAsManifestResource((Asset)new StringAsset((String)this.fraction.getTokenIssuer().get()), "MP-JWT-ISSUER");
        }
        if (this.fraction.getPublicKey() != null) {
            String publicKey = this.fraction.getPublicKey();
            log.debugf("PublicKey: %s", (Object)publicKey);
            if (publicKey.startsWith("file:") || publicKey.startsWith("classpath:")) {
                log.warn((Object)"Using 'thorntail.microprofile.jwt.token.signer-pub-key' for the 'file:' or 'classpath:' key assets is deprecated, use the 'thorntail.microprofile.jwt.token.signer-pub-key-location' property instead");
                war.addAsManifestResource((Asset)new StringAsset(publicKey), "MP-JWT-SIGNER-KEY-LOCATION");
            } else {
                war.addAsManifestResource((Asset)new StringAsset(publicKey), "MP-JWT-SIGNER");
            }
        }
        if (this.fraction.getPublicKeyLocation() != null) {
            if (this.fraction.getPublicKey() != null) {
                log.warn((Object)"'thorntail.microprofile.jwt.token.signer-pub-key' property has already been set, 'thorntail.microprofile.jwt.token.signer-pub-key-location' property will be ignored");
            } else {
                log.debugf("PublicKey location: %s", (Object)this.fraction.getPublicKeyLocation());
                war.addAsManifestResource((Asset)new StringAsset(this.fraction.getPublicKeyLocation()), "MP-JWT-SIGNER-KEY-LOCATION");
            }
        }
        war.addAsManifestResource((Asset)new StringAsset("" + this.fraction.getExpGracePeriodSecs().get()), "MP-JWT-EXP-GRACE");
        if (this.fraction.isDefaultMissingMethodPermissionsDenyAccess()) {
            war.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "MP-JWT-DENY-NONANNOTATED-METHODS");
        }
        if (this.fraction.getJwksUri() != null) {
            log.warn((Object)"Using 'thorntail.microprofile.jwt.token.jwks-uri' for the HTTPS based JWK sets is deprecated, use the 'thorntail.microprofile.jwt.token.signer-pub-key-location' property instead");
            if (this.fraction.getPublicKeyLocation() != null || this.fraction.getPublicKey() != null) {
                log.warn((Object)"One of 'thorntail.microprofile.jwt.token.signer-pub-key' or 'thorntail.microprofile.jwt.token.signer-pub-key-location' properties has already been set. 'thorntail.microprofile.jwt.token.jwks-uri' propery will be ignored");
            } else {
                log.debugf("JwksUri: %s", (Object)this.fraction.getJwksUri());
                war.addAsManifestResource((Asset)new StringAsset(this.fraction.getJwksUri()), "MP-JWT-SIGNER-KEY-LOCATION");
            }
        }
        if (this.fraction.getPublicKeyLocation() != null && this.fraction.getPublicKeyLocation().startsWith("https:") || this.fraction.getJwksUri() != null) {
            war.addAsManifestResource((Asset)new StringAsset(((Integer)this.fraction.getJwksRefreshInterval().get()).toString()), "MP-JWT-JWKS-REFRESH");
        }
        if (this.fraction.getTokenHeader() != null) {
            log.debugf("tokenHeader: %s", this.fraction.getTokenHeader());
            war.addAsManifestResource((Asset)new StringAsset((String)this.fraction.getTokenHeader().get()), "MP-JWT-TOKEN-HEADER");
        }
        if (this.fraction.getTokenCookie() != null) {
            log.debugf("tokenCookie: %s", (Object)this.fraction.getTokenCookie());
            war.addAsManifestResource((Asset)new StringAsset(this.fraction.getTokenCookie()), "MP-JWT-TOKEN-COOKIE");
        }
        if (this.fraction.getDefaultGroupsClaim() != null) {
            log.debugf("defaultGroupsClaim: %s", (Object)this.fraction.getDefaultGroupsClaim());
            war.addAsManifestResource((Asset)new StringAsset(this.fraction.getDefaultGroupsClaim()), "MP-JWT-DEFAULT-GROUPS-CLAIM");
        }
        if (this.fraction.getGroupsPath() != null) {
            log.debugf("groupsPath: %s", (Object)this.fraction.getGroupsPath());
            war.addAsManifestResource((Asset)new StringAsset(this.fraction.getGroupsPath()), "MP-JWT-GROUPS-PATH");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("war: " + war.toString(true)));
        }
        this.addFilterRegistrar();
        if (this.fraction.getRolesPropertiesMap() != null) {
            this.createRolePropertiesFileFromMap();
        }
    }

    private void selectSecurityDomain(WARArchive war, String realm) {
        WebXmlAsset webXml = war.findWebXmlAsset();
        webXml.setLoginConfig(MP_JWT_AUTH_METHOD, realm);
        JBossWebAsset jBossWeb = war.findJbossWebAsset();
        jBossWeb.setSecurityDomain(realm);
    }

    private void createRolePropertiesFileFromMap() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.fraction.getRolesPropertiesMap().entrySet()) {
            sb.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        this.archive.add((Asset)new ByteArrayAsset(sb.toString().getBytes()), "WEB-INF/classes/autogenerated-roles.properties");
    }

    private void addFilterRegistrar() {
        JAXRSArchive jaxrsArchive = (JAXRSArchive)this.archive.as(JAXRSArchive.class);
        WebXmlAsset webXmlAsset = jaxrsArchive.findWebXmlAsset();
        String userProviders = webXmlAsset.getContextParam(RESTEASY_PROVIDERS);
        String filterRegistrar = JWTAuthorizationFilterRegistrar.class.getName();
        String providers = userProviders == null ? filterRegistrar : userProviders + "," + filterRegistrar;
        webXmlAsset.setContextParam(RESTEASY_PROVIDERS, new String[]{providers});
    }
}

