/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.runtime;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.config.security.Flag;
import org.wildfly.swarm.microprofile.jwtauth.MicroProfileJWTAuthFraction;
import org.wildfly.swarm.security.SecurityFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class MPJWTLoginModuleCustomizer
implements Customizer {
    @Inject
    SecurityFraction securityFraction;
    @Inject
    private MicroProfileJWTAuthFraction mpJwtFraction;

    public void customize() throws ModuleLoadException, IOException {
        String realm = (String)this.mpJwtFraction.getJwtRealm().get();
        if (!realm.isEmpty() && this.securityFraction.subresources().securityDomain(realm) == null) {
            this.securityFraction.securityDomain(realm, domain -> domain.jaspiAuthentication(auth -> {
                auth.loginModuleStack("roles-lm-stack", stack -> stack.loginModule("0", module -> {
                    module.code("org.wildfly.swarm.microprofile.jwtauth.deployment.auth.jaas.JWTLoginModule");
                    module.flag(Flag.REQUIRED);
                    if (this.mpJwtFraction.getRolesPropertiesMap() != null) {
                        module.moduleOption("rolesProperties", (Object)"autogenerated-roles.properties");
                    } else if (!((String)this.mpJwtFraction.getRolesPropertiesFile().get()).isEmpty()) {
                        module.moduleOption("rolesProperties", this.mpJwtFraction.getRolesPropertiesFile().get());
                    }
                }));
                auth.authModule("http", module -> {
                    module.code("org.wildfly.extension.undertow.security.jaspi.modules.HTTPSchemeServerAuthModule");
                    module.module("org.wildfly.extension.undertow");
                    module.flag(Flag.REQUIRED);
                    module.loginModuleStackRef("roles-lm-stack");
                });
            }));
        }
    }
}

