/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.deployment;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import java.security.AccessController;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class OpenApiServletContextListener
implements ServletContextListener {
    private final OpenApiConfig config;

    public OpenApiServletContextListener() {
        this(ConfigProvider.getConfig());
    }

    public OpenApiServletContextListener(Config config) {
        this.config = new OpenApiConfigImpl(config);
    }

    public void contextInitialized(ServletContextEvent sce) {
        OpenApiDocument openApiDocument = OpenApiDocument.INSTANCE;
        openApiDocument.modelFromReader((OpenAPI)this.modelFromReader());
        openApiDocument.filter(this.getFilter());
        openApiDocument.initialize();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private OpenAPIImpl modelFromReader() {
        ClassLoader cl = OpenApiServletContextListener.getContextClassLoader();
        if (cl == null) {
            cl = OpenApiServletContextListener.class.getClassLoader();
        }
        return OpenApiProcessor.modelFromReader((OpenApiConfig)this.config, (ClassLoader)cl);
    }

    private OASFilter getFilter() {
        ClassLoader cl = OpenApiServletContextListener.getContextClassLoader();
        if (cl == null) {
            cl = OpenApiServletContextListener.class.getClassLoader();
        }
        return OpenApiProcessor.getFilter((OpenApiConfig)this.config, (ClassLoader)cl);
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }
}

