/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.util.ArchiveUtil;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import javax.inject.Inject;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.container.runtime.cdi.DeploymentContext;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;

@DeploymentScoped
public class OpenApiDeploymentProcessor
implements DeploymentProcessor {
    private static final String LISTENER_CLASS = "org.wildfly.swarm.microprofile.openapi.deployment.OpenApiServletContextListener";
    private final OpenApiConfig config;
    private final Archive archive;
    private final IndexView index;
    @Inject
    DeploymentContext deploymentContext;

    public OpenApiDeploymentProcessor(OpenApiConfig config, Archive archive) {
        this.config = config;
        this.archive = archive;
        this.index = ArchiveUtil.archiveToIndex((OpenApiConfig)config, (Archive)archive);
    }

    @Inject
    public OpenApiDeploymentProcessor(Archive archive) {
        this.config = ArchiveUtil.archiveToConfig((Archive)archive);
        this.archive = archive;
        this.index = ArchiveUtil.archiveToIndex((OpenApiConfig)this.config, (Archive)archive);
    }

    public void process() throws Exception {
        if (this.deploymentContext != null && this.deploymentContext.isImplicit()) {
            return;
        }
        try {
            WARArchive warArchive = (WARArchive)this.archive.as(WARArchive.class);
            warArchive.findWebXmlAsset().addListener(LISTENER_CLASS);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register OpenAPI listener", e);
        }
        OpenApiStaticFile staticFile = ArchiveUtil.archiveToStaticFile((Archive)this.archive);
        OpenApiDocument openApiDocument = OpenApiDocument.INSTANCE;
        openApiDocument.config(this.config);
        openApiDocument.modelFromStaticFile((OpenAPI)OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
        openApiDocument.modelFromAnnotations((OpenAPI)OpenApiProcessor.modelFromAnnotations((OpenApiConfig)this.config, (IndexView)this.index));
    }
}

