/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime;

import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class OpenApiHttpHandler
implements HttpHandler {
    private static final String OAI = "/openapi";
    private static final String ALLOWED_METHODS = "GET, HEAD, OPTIONS";
    private static final String QUERY_PARAM_FORMAT = "format";
    private final Map<OpenApiSerializer.Format, String> cachedModels;
    private final HttpHandler next;

    public OpenApiHttpHandler(HttpHandler next) {
        this.next = next;
        this.cachedModels = new ConcurrentHashMap<OpenApiSerializer.Format, String>();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (OAI.equalsIgnoreCase(exchange.getRequestPath()) && OpenApiDocument.INSTANCE.isSet()) {
            if (exchange.getRequestMethod().equals(Methods.GET)) {
                this.sendOai(exchange);
            } else if (exchange.getRequestMethod().equals(Methods.OPTIONS)) {
                this.sendPreflight(exchange);
            } else {
                this.next.handleRequest(exchange);
            }
        } else {
            this.next.handleRequest(exchange);
        }
    }

    private void sendPreflight(HttpServerExchange exchange) {
        OpenApiHttpHandler.addCorsResponseHeaders(exchange);
        exchange.getResponseSender().send(ALLOWED_METHODS);
    }

    private void sendOai(HttpServerExchange exchange) throws IOException {
        String accept = exchange.getRequestHeaders().getFirst(Headers.ACCEPT);
        Deque formatQueryParams = (Deque)exchange.getQueryParameters().get(QUERY_PARAM_FORMAT);
        String formatParam = null;
        if (formatQueryParams != null) {
            formatParam = (String)formatQueryParams.getFirst();
        }
        OpenApiSerializer.Format format = OpenApiSerializer.Format.YAML;
        if (accept != null && accept.contains(OpenApiSerializer.Format.JSON.getMimeType()) || OpenApiSerializer.Format.JSON.name().equalsIgnoreCase(formatParam) || OpenApiSerializer.Format.JSON.getMimeType().equalsIgnoreCase(formatParam)) {
            format = OpenApiSerializer.Format.JSON;
        }
        String oai = this.getCachedOaiString(format);
        OpenApiHttpHandler.addCorsResponseHeaders(exchange);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, format.getMimeType());
        exchange.getResponseSender().send(oai);
    }

    private String getCachedOaiString(OpenApiSerializer.Format format) {
        return this.cachedModels.computeIfAbsent(format, this::getModel);
    }

    private String getModel(OpenApiSerializer.Format format) {
        try {
            return OpenApiSerializer.serialize((OpenAPI)OpenApiDocument.INSTANCE.get(), (OpenApiSerializer.Format)format);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize OpenAPI in " + format, e);
        }
    }

    private static void addCorsResponseHeaders(HttpServerExchange exchange) {
        HeaderMap headerMap = exchange.getResponseHeaders();
        headerMap.put(new HttpString("Access-Control-Allow-Origin"), "*");
        headerMap.put(new HttpString("Access-Control-Allow-Credentials"), "true");
        headerMap.put(new HttpString("Access-Control-Allow-Methods"), ALLOWED_METHODS);
        headerMap.put(new HttpString("Access-Control-Allow-Headers"), "Content-Type, Authorization");
        headerMap.put(new HttpString("Access-Control-Max-Age"), "86400");
    }
}

