/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mpopentracing.deployment;

import io.opentracing.contrib.interceptors.OpenTracingInterceptor;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.jboss.logging.Logger;
import org.wildfly.swarm.mpopentracing.deployment.TracerProducer;

public class OpenTracingCDIExtension
implements Extension {
    private static final Logger logger = Logger.getLogger(OpenTracingCDIExtension.class);

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager manager) {
        logger.info((Object)"Registering Tracer CDI producer");
        String extensionName = OpenTracingCDIExtension.class.getName();
        for (Class clazz : new Class[]{TracerProducer.class, OpenTracingInterceptor.class}) {
            bbd.addAnnotatedType(manager.createAnnotatedType(clazz), extensionName + "_" + clazz.getName());
        }
    }
}

