/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mpopentracing.runtime;

import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class TracingInstaller
implements DeploymentProcessor {
    private static final String RESTEASY_PROVIDERS = "resteasy.providers";
    private static final String DEPLOYMENT_PACKAGE = "org.wildfly.swarm.mpopentracing.deployment";
    private static final String TRACING_FEATURE = "io.smallrye.opentracing.SmallRyeTracingDynamicFeature";
    private static final String CONTEXT_LISTENER = "org.wildfly.swarm.mpopentracing.deployment.OpenTracingContextInitializer";
    private final Archive<?> archive;

    @Inject
    public TracingInstaller(Archive archive) {
        this.archive = archive;
    }

    public void process() throws Exception {
        if (this.archive.getName().endsWith(".war")) {
            JAXRSArchive jaxrsArchive = (JAXRSArchive)this.archive.as(JAXRSArchive.class);
            WebXmlAsset webXmlAsset = jaxrsArchive.findWebXmlAsset();
            webXmlAsset.addListener(CONTEXT_LISTENER);
            String userProviders = webXmlAsset.getContextParam(RESTEASY_PROVIDERS);
            String providers = userProviders == null ? TRACING_FEATURE : userProviders + "," + TRACING_FEATURE;
            webXmlAsset.setContextParam(RESTEASY_PROVIDERS, new String[]{providers});
        }
    }
}

