/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.opentracing.tracer.deployment;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.util.GlobalTracer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.logging.Logger;

public class TracerResolverListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(TracerResolverListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        Tracer tracer;
        ServletContext servletContext = sce.getServletContext();
        String skipParameter = servletContext.getInitParameter("skipOpenTracingResolver");
        if (skipParameter != null && Boolean.parseBoolean(skipParameter)) {
            logger.info((Object)"Skipping the OpenTracing TracerResolver. Your application is expected to set a tracer to GlobalTracer explicitly.");
            return;
        }
        if (GlobalTracer.isRegistered()) {
            logger.info((Object)"A Tracer is already registered at the GlobalTracer. Skipping resolution via TraceResolver.");
        }
        if ((tracer = TracerResolver.resolveTracer()) != null) {
            logger.info((Object)String.format("Registering resolved tracer %s to GlobalTracer.", tracer.getClass().getCanonicalName()));
            GlobalTracer.register((Tracer)tracer);
        } else {
            logger.info((Object)"No Tracerresolver found on classpath!");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

