/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.opentracing.tracer.runtime;

import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.opentracing.tracer.OpenTracingTracerResolverFraction;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class OpenTracingTracerInstaller
implements DeploymentProcessor {
    private static final String DEPLOYMENT_PACKAGE = OpenTracingTracerResolverFraction.class.getPackage().getName() + ".deployment";
    private static final String CONTEXT_LISTENER = DEPLOYMENT_PACKAGE + ".TracerResolverListener";
    private final Archive<?> archive;

    @Inject
    public OpenTracingTracerInstaller(Archive archive) {
        this.archive = archive;
    }

    public void process() throws Exception {
        if (this.archive.getName().endsWith(".war")) {
            WARArchive webArchive = (WARArchive)this.archive.as(WARArchive.class);
            WebXmlAsset webXml = webArchive.findWebXmlAsset();
            webXml.addListener(CONTEXT_LISTENER);
        }
    }
}

