/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.resource.adapters.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.wildfly.swarm.internal.FileSystemLayout;
import org.wildfly.swarm.resource.adapters.RARArchive;
import org.wildfly.swarm.spi.api.DefaultDeploymentFactory;
import org.wildfly.swarm.spi.api.DependenciesContainer;

@ApplicationScoped
public class DefaultRarDeploymentFactory
extends DefaultDeploymentFactory {
    public static RARArchive archiveFromCurrentApp() throws Exception {
        RARArchive archive = (RARArchive)ShrinkWrap.create(RARArchive.class, (String)DefaultRarDeploymentFactory.determineName());
        DefaultRarDeploymentFactory factory = new DefaultRarDeploymentFactory();
        factory.setup(archive);
        return archive;
    }

    public int getPriority() {
        return 0;
    }

    public String getType() {
        return "rar";
    }

    public Archive<?> create() throws Exception {
        return DefaultRarDeploymentFactory.archiveFromCurrentApp();
    }

    public boolean setupUsingMaven(Archive<?> givenArchive) throws Exception {
        Path webapp;
        final DependenciesContainer archive = (DependenciesContainer)givenArchive;
        FileSystemLayout fsLayout = FileSystemLayout.create();
        final Path classes = fsLayout.resolveBuildClassesDir();
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), "WEB-INF/classes/" + DefaultRarDeploymentFactory.this.convertSeparators(simple));
                    if (simple.toString().contains("WEB-INF")) {
                        archive.add((Asset)new FileAsset(file.toFile()), DefaultRarDeploymentFactory.this.convertSeparators(simple));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        if (Files.exists(webapp = fsLayout.resolveSrcWebAppDir(), new LinkOption[0])) {
            success = true;
            Files.walkFileTree(webapp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = webapp.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), DefaultRarDeploymentFactory.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        archive.addAllDependencies();
        return success;
    }

    protected static String determineName() {
        return DefaultDeploymentFactory.determineName((String)".rar");
    }
}

