/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.spi.api.OutboundSocketBinding;
import org.wildfly.swarm.spi.api.SocketBinding;

public class SocketBindingGroup {
    private final String name;
    private String defaultInterace;
    private String portOffsetExpression;
    private List<SocketBinding> socketBindings = new ArrayList<SocketBinding>();
    private List<OutboundSocketBinding> outboundSocketBindings = new ArrayList<OutboundSocketBinding>();

    public SocketBindingGroup(String name, String defaultInterface, String portOffsetExpression) {
        this.name = name;
        this.defaultInterace = defaultInterface;
        this.portOffsetExpression = portOffsetExpression;
    }

    public String name() {
        return this.name;
    }

    public String defaultInterface() {
        return this.defaultInterace;
    }

    public SocketBindingGroup defaultInterface(String defaultInterface) {
        this.defaultInterace = defaultInterface;
        return this;
    }

    public String portOffsetExpression() {
        return this.portOffsetExpression;
    }

    public SocketBindingGroup portOffset(String expr) {
        this.portOffsetExpression = expr;
        return this;
    }

    public SocketBindingGroup portOffset(int offset) {
        this.portOffsetExpression = "" + offset;
        return this;
    }

    public SocketBindingGroup socketBinding(SocketBinding binding) {
        this.socketBindings.add(binding);
        return this;
    }

    public SocketBinding socketBinding(String name) {
        return this.socketBindings.stream().filter(e -> e.name().equals(name)).findFirst().orElse(null);
    }

    public List<SocketBinding> socketBindings() {
        return this.socketBindings;
    }

    public SocketBindingGroup outboundSocketBinding(OutboundSocketBinding binding) {
        this.outboundSocketBindings.add(binding);
        return this;
    }

    public List<OutboundSocketBinding> outboundSocketBindings() {
        return this.outboundSocketBindings;
    }
}

