/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api.config;

import org.wildfly.swarm.spi.api.config.CompositeKey;
import org.wildfly.swarm.spi.api.config.SimpleKey;

public interface ConfigKey {
    public static final SimpleKey EMPTY = new SimpleKey();
    public static final char START_DELIM = '[';
    public static final char END_DELIM = ']';

    public String name();

    public String propertyName();

    public SimpleKey head();

    public ConfigKey subkey(int var1);

    public ConfigKey append(String ... var1);

    public ConfigKey append(ConfigKey var1);

    public boolean isChildOf(ConfigKey var1);

    public void replace(int var1, String var2);

    public static ConfigKey of(String ... parts) {
        return new CompositeKey(parts);
    }

    public static ConfigKey parse(String str) {
        ConfigKey key = EMPTY;
        if (str.startsWith("swarm.")) {
            str = str.replaceFirst("swarm.", "thorntail.");
        }
        int len = str.length();
        StringBuilder segment = new StringBuilder();
        block4: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '[': {
                    ++i;
                    while (i < len) {
                        c = str.charAt(i);
                        if (c == ']') continue block4;
                        segment.append(c);
                        ++i;
                    }
                    break block4;
                }
                case '.': {
                    key = key.append(segment.toString());
                    segment = new StringBuilder();
                    continue block4;
                }
                default: {
                    segment.append(c);
                }
            }
        }
        if (segment.length() > 0) {
            key = key.append(segment.toString());
        }
        return key;
    }
}

